//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: doublelabel.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>

#include "doublelabel.h"
#include <qvalidator.h>
#include <qpalette.h>
#include <stdio.h>
#include <values.h>

#include "utils.h"

//---------------------------------------------------------
//   DoubleLabel
//---------------------------------------------------------

DoubleLabel::DoubleLabel(double _val, double m, double mx, QWidget* parent)
   : Dentry(parent), _specialText("---")
      {
      min = m;
      max = mx;
      _precision = 3;
      setValue(_val);
      }

//---------------------------------------------------------
//   setString
//---------------------------------------------------------

bool DoubleLabel::setString(double v)
      {
      QString s;
      if (v < min || v > max) {
            setText(_specialText);
            return true;
            }
      s.setNum(v, 'f', _precision);
      setText(s);
      return false;
      }

//---------------------------------------------------------
//   setSValue
//---------------------------------------------------------

bool DoubleLabel::setSValue(const QString& s)
      {
      int v = s.toInt();
      if (v != val) {
            setValue(v);
            emit valueChanged(val);
            }
      return false;
      }

//---------------------------------------------------------
//   incValue
//---------------------------------------------------------

void DoubleLabel::incValue(double)
      {
      if (val+1 < max) {
            setValue(val+1);
            emit valueChanged(val);
            }
      }

//---------------------------------------------------------
//   decValue
//---------------------------------------------------------

void DoubleLabel::decValue(double)
      {
      if (val-1 > min) {
            setValue(val-1);
            emit valueChanged(val);
            }
      }

//---------------------------------------------------------
//   setPrecision
//---------------------------------------------------------

void DoubleLabel::setPrecision(int v)
      {
      _precision = v;
      setString(val);
      }

