//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: score.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//  (C) Copyright 1999,2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __NOTEN_H__
#define __NOTEN_H__

#include <qwidget.h>
#include "midieditor.h"
#include "noteinfo.h"
#include "cobject.h"
#include "tools.h"

#include <qmainwindow.h>

class QAction;
class MidiEvent;
class QLabel;
class ScoreCanvas;
class MidiTrack;
class Track;
class ScoreConfig;
class QPushButton;
class QComboBox;
class Action;
class QToolButton;
class Toolbar1;
class PartList;
class Xml;
class ScrollScale;
class MidiPart;
class QButtonGroup;

//---------------------------------------------------------
//   Score
//---------------------------------------------------------

class Score : public MidiEditor {
      MidiEvent* selEvent;
      MidiPart* selPart;
      int selTick;
      Tool tool;
      ScoreCanvas* canvas;
      NoteInfo* info;
      bool steprec;
      ScoreConfig* scoreConfig;
      QToolButton* noteButtons[9];
      bool n1, n2;
      QComboBox* quant;
      EditToolBar* etb;
      int quantId;
      Toolbar1* toolbar;
      QString canvasBg;      // background Pixmap
      QWidget* dynPalette;
      ScrollScale* hscroll;
      ScrollScale* vscroll;
      QButtonGroup* paletteBg;
      QToolBar* tools;

      static int _quantInit, _rasterInit;

      Q_OBJECT
      void setQuant2();

      virtual void closeEvent(QCloseEvent*);

   private slots:
      void setRaster(int);
      void setQuant(int);
      void setSelection(int, MidiEvent*, MidiPart*);
      void soloChanged(bool flag);
      void soloChanged(Track*);
      void setSteprec(bool flag) { steprec = flag; }
      void n1Change(bool n);
      void n2Change(bool n);
      void setQuant1(QAction*);
      void noteinfoChanged(NoteInfo::ValType, int);
      void configBackground();
      void openPageSettings();
      void openDynamicsPalette();
      void setPaletteItem(int);

   public slots:
      void songChanged(int);
      void showScoreConfig();

   signals:
      void rasterChanged(int);
      void quantChanged(int);
      void deleted(int);

   public:
      Score(PartList*);
      ~Score();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      static void readConfiguration(Xml&);
      static void writeConfiguration(int, Xml&);
      };

#endif

