//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midiserial.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDISERIAL_H__
#define __MIDISERIAL_H__

#include <termios.h>
#include "midirawdev.h"

enum SerialType { RAW_DEVICE, SERIAL_PORT };

//---------------------------------------------------------
//   SerialDevice
//---------------------------------------------------------

class SerialDevice {
      QString _name;
      QString _path;
      SerialType _type;
      int _speed;        // serial baud rate
      int _handshaking;
      int _vports;       // virtual ports

      int _fd;
      int refs;
      int curPort;      // current virtual port

   public:
      SerialDevice(const QString&, SerialType, int s=B38400, int vd = 1);
      SerialDevice();
      ~SerialDevice();

      const QString name() const    { return _name; }
      const QString path() const    { return _path; }
      SerialType type() const        { return _type; }
      int speed() const              { return _speed; }
      int handshaking() const        { return _handshaking; }
      int vports() const             { return _vports; }
      void setName(const QString& s) { _name = s; }
      void setPath(const QString& s) { _path = s; }
      void setType(SerialType t)     { _type = t; }
      void setSpeed(int v)           { _speed = v; }
      void setHandshaking(int v)     { _handshaking = v; }
      void setVports(int v);

      void incRef(int val);
      const QString open(int);
      void close(int);
      int read(int, unsigned char*, int);
      int write(int, const unsigned char*, int);
      int fd() const { return _fd; }
      bool busy()   { return refs != 0; }
      };

typedef std::list<SerialDevice*> SerialDeviceList;
typedef std::list<SerialDevice*>::iterator iSerialDevice;

//---------------------------------------------------------
//   MidiSerialDevice
//---------------------------------------------------------

class MidiSerialDevice : public MidiRawDevice {
      SerialDevice* dev;
      int vdev;

   protected:
      virtual int read(unsigned char*p, int n)  {
            return dev->read(vdev, p, n);
            }
      virtual int write(const unsigned char* p, int n) {
            return dev->write(vdev, p, n);
            }
   public:
      MidiSerialDevice(SerialDevice* dev, int vd, const QString& name);
      ~MidiSerialDevice();
      virtual QString open(int)     { return dev->open(vdev); }
      virtual void close()          { dev->close(vdev); }
      virtual int selectRfd()       { return dev->fd(); }
      virtual int selectWfd()       { return dev->fd(); }
      };

extern SerialDeviceList serialDevices;

class Xml;
class QString;

extern void writeSerialPorts(int, Xml&);
extern void readSerialPort(Xml&);
extern bool deleteSerialDevice(const QString& path);
#endif

