# Copyright (C) Jan 2020 Mellanox Technologies Ltd. All rights reserved.   
#                                                                           
# This software is available to you under a choice of one of two            
# licenses.  You may choose to be licensed under the terms of the GNU       
# General Public License (GPL) Version 2, available from the file           
# COPYING in the main directory of this source tree, or the                 
# OpenIB.org BSD license below:                                             
#                                                                           
#     Redistribution and use in source and binary forms, with or            
#     without modification, are permitted provided that the following       
#     conditions are met:                                                   
#                                                                           
#      - Redistributions of source code must retain the above               
#        copyright notice, this list of conditions and the following        
#        disclaimer.                                                        
#                                                                           
#      - Redistributions in binary form must reproduce the above            
#        copyright notice, this list of conditions and the following        
#        disclaimer in the documentation and/or other materials             
#        provided with the distribution.                                    
#                                                                           
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,         
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF        
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND                     
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS       
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN        
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN         
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE          
# SOFTWARE.                                                                 
# --                                                                        


#######################################################
# 
# DumpCommand.py
# Python implementation of the Class DumpCommand
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:12:00 AM
# Original author: talve
# 
#######################################################
from commands.ResDumpCommand import ResDumpCommand
from commands.CommandFactory import CommandFactory
from utils import constants as cs
from validation.CapabilityValidator import CapabilityValidator
from resource_data.DumpData import DumpData
from resource_data.DataPrinter import DataPrinter


class DumpCommand(ResDumpCommand):
    """This class is responsible for performing the dump command flow by validate,
    getting the data and print it.
    """
    def __init__(self, **kwargs):
        """DumpCommand initialization.
        """
        self.device_name = kwargs[cs.UI_ARG_DEVICE]
        self.segment = kwargs[cs.UI_ARG_SEGMENT]
        self.vHCAid = kwargs[cs.UI_ARG_VHCAID]
        self.index1 = kwargs[cs.UI_ARG_INDEX1]
        self.index2 = kwargs[cs.UI_ARG_INDEX2]
        self.numOfObj1 = kwargs[cs.UI_ARG_NUMOFOBJ1]
        self.numOfObj2 = kwargs[cs.UI_ARG_NUMOFOBJ2]
        self.depth = kwargs[cs.UI_ARG_DEPTH]
        self.bin = kwargs[cs.UI_ARG_BIN]
        self.data = None

    def get_data(self):
        """call the QueryData for getting the dump data.
        """
        self.data = DumpData.get_dump(device_name=self.device_name,
                                      segment=self.segment,
                                      vHCAid=self.vHCAid,
                                      index1=self.index1,
                                      index2=self.index2,
                                      numOfObj1=self.numOfObj1,
                                      numOfObj2=self.numOfObj2,
                                      depth=self.depth,
                                      bin=self.bin)

    def print_data(self):
        """call the data printer with the right configuration for print the dump data to
        screen or in a binary format (choosed by the user).
        """
        DataPrinter.print_dump_data(self.data, self.bin)

    def validate(self):
        """call the capability validator and check if the core dump supported by the FW.
        """
        validation_status = False

        if CapabilityValidator.validate():
            validation_status = True
        else:
            print("resource dump register is not supported by FW")

        return validation_status


CommandFactory.register(cs.RESOURCE_DUMP_COMMAND_TYPE_DUMP, DumpCommand)
