/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __FILE_ALLOCATION_MANAGER_H__
#define __FILE_ALLOCATION_MANAGER_H__

#include <bonobo/bonobo-event-source.h>
#include "project-engine/allocation-manager.h"
#include "libmrproject/GNOME_MrProject.h"
#define TYPE_FILE_ALLOCATION_MANAGER	      (file_allocation_manager_get_type ())
#define FILE_ALLOCATION_MANAGER(obj)	      (GTK_CHECK_CAST ((obj), TYPE_FILE_ALLOCATION_MANAGER, FileAllocationManager))
#define FILE_ALLOCATION_MANAGER_CLASS(klass)  (GTK_CHECK_CLASS_CAST ((klass), TYPE_FILE_ALLOCATION_MANAGER, FileAllocationManagerClass))
#define IS_FILE_ALLOCATION_MANAGER(obj)	      (GTK_CHECK_TYPE ((obj), TYPE_FILE_ALLOCATION_MANAGER))
#define IS_FILE_ALLOCATION_MANAGER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((obj), TYPE_FILE_ALLOCATION_MANAGER))

typedef struct _FileAllocationManager      FileAllocationManager;
typedef struct _FileAllocationManagerClass FileAllocationManagerClass;
typedef struct _FileAllocationManagerPriv  FileAllocationManagerPriv;

struct _FileAllocationManager 
{
        AllocationManager            parent;
        
        FileAllocationManagerPriv   *priv;
};

struct _FileAllocationManagerClass 
{
        AllocationManagerClass       parent_class;
        
};

GtkType             file_allocation_manager_get_type (void);
AllocationManager * file_allocation_manager_new      (BonoboEventSource *event_source);
#endif /* __FILE_ALLOCATION_MANAGER_HH__ */
