/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 * Copyright (C) 2001 Richard Hult     <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 *         Richard Hult     <rhult@codefactory.se>
 */

#ifndef __NETWORK_CANVAS_H__
#define __NETWORK_CANVAS_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <libgnomeui/gnome-canvas.h>
#include "util/corba-utils.h"

#define NETWORK_CANVAS_TYPE        (network_canvas_get_type ())
#define NETWORK_CANVAS(o)          (GTK_CHECK_CAST ((o), NETWORK_CANVAS_TYPE, NetworkCanvas))
#define NETWORK_CANVAS_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), NETWORK_CANVAS_TYPE, NetworkCanvasClass))
#define IS_NETWORK_CANVAS(o)       (GTK_CHECK_TYPE ((o), NETWORK_CANVAS_TYPE))
#define IS_NETWORK_CANVAS_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), NETWORK_CANVAS_TYPE))

typedef struct _NetworkCanvas        NetworkCanvas;
typedef struct _NetworkCanvasClass   NetworkCanvasClass;
typedef struct _NetworkCanvasPriv    NetworkCanvasPriv;

struct _NetworkCanvas {
        GnomeCanvas          parent;
        NetworkCanvasPriv   *priv;
};

struct _NetworkCanvasClass {
        GnomeCanvasClass     parent_class;
};

GtkType       network_canvas_get_type       (void);
GtkWidget    *network_canvas_new            (void);
void          network_canvas_insert_task    (NetworkCanvas   *network_canvas,
                                             GM_Task         *task);
void          network_canvas_remove_tasks   (NetworkCanvas   *network_canvas,
                                             GSList          *tasks);
void          network_canvas_update_task    (NetworkCanvas   *network_canvas,
                                             GM_Task         *task);
void          network_canvas_reparent_task  (NetworkCanvas   *network_canvas,
                                             GM_Id            task_id,
                                             GM_Id            new_parent_id);
void          network_canvas_link           (NetworkCanvas   *network_canvas,
                                             GM_Dependency   *dependency);
void          network_canvas_unlink         (NetworkCanvas   *network_canvas,
                                             GM_Dependency   *dependency);
void          network_canvas_clear          (NetworkCanvas   *canvas);
void          network_canvas_sort           (NetworkCanvas   *canvas,
					     GM_IdSeq        *ids);

#endif /* __NETWORK_CANVAS_H__ */

