/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef _GANTT_ITEM_H_
#define _GANTT_ITEM_H_

#include <libgnomeui/gnome-canvas.h>
#include <gal/e-table/e-table-model.h>
#include <gal/e-table/e-table-selection-model.h>
#include <gal/e-table/e-table-defines.h>
#include "gantt-printable.h"

#define GANTT_ITEM_TYPE        (gantt_item_get_type ())
#define GANTT_ITEM(o)          (GTK_CHECK_CAST ((o), GANTT_ITEM_TYPE, GanttItem))
#define GANTT_ITEM_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GANTT_ITEM_TYPE, GanttItemClass))
#define IS_GANTT_ITEM(o)      (GTK_CHECK_TYPE ((o), GANTT_ITEM_TYPE))
#define IS_GANTT_ITEM_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GANTT_ITEM_TYPE))

typedef struct _GanttItemPriv GanttItemPriv;

typedef struct {
	GnomeCanvasItem   parent;
	GanttItemPriv    *priv;
} GanttItem;

typedef struct {
	GnomeCanvasItemClass parent_class;

	void        (*cursor_change) (GanttItem *gantt_item, int row);
	void        (*double_click)  (GanttItem *gantt_item, int row);
	gint        (*right_click)   (GanttItem *gantt_item, int row, int col, GdkEvent *event);
	gint        (*click)         (GanttItem *gantt_item, int row, int col, GdkEvent *event);
	gint        (*key_press)     (GanttItem *gantt_item, int row, int col, GdkEvent *event);
} GanttItemClass;

GtkType    gantt_item_get_type (void);
void       gantt_item_redraw_range (GanttItem *gantt_item, int start_row, int end_row);
time_t	   gantt_item_get_first_visible_time (GanttItem *gantt_item);

GanttPrintable *gantt_item_get_printable (GanttItem *item);

void gantt_item_select_row (GanttItem *gantt, guint row);
void gantt_item_unselect_all (GanttItem *gantt);
void gantt_item_select_row_item (GanttItem *gantt, GnomeCanvasItem *row_item);


#endif /* _GANTT_ITEM_H_ */

