/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import logformat.slog2.CategoryMap;
import viewer.legends.CategoryIcon;
import viewer.legends.LegendComparators;

public class LegendTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2300L;
    public static final int ICON_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int VISIBILITY_COLUMN = 2;
    public static final int SEARCHABILITY_COLUMN = 3;
    public static final int COUNT_COLUMN = 4;
    public static final int INCL_RATIO_COLUMN = 5;
    public static final int EXCL_RATIO_COLUMN = 6;
    private static final String[] COLUMN_TITLES = new String[]{"Topo", "Name", "V", "S", "count", "incl", "excl"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Topology/Color", "Category Name", "Visibility", "Searchability", "category Count in the whole logfile", "Inclusive Ratio", "Exclusive Ratio"};
    private static final Class[] COLUMN_CLASSES = new Class[]{CategoryIcon.class, String.class, Boolean.class, Boolean.class, Long.class, Float.class, Float.class};
    private static final Color[] COLUMN_TITLE_FORE_COLORS = new Color[]{Color.magenta, Color.pink, Color.green, Color.yellow, Color.white, Color.white, Color.white};
    private static final Color[] COLUMN_TITLE_BACK_COLORS = new Color[]{Color.black, Color.gray, Color.darkGray.darker(), Color.blue.darker(), Color.gray, Color.gray, Color.gray};
    private static final boolean[] COLUMN_TITLE_RAISED_ICONS = new boolean[]{false, false, true, false, false, false, false};
    private List objdef_list = null;
    private List icon_list = null;

    public LegendTableModel(CategoryMap categoryMap) {
        this.objdef_list = new ArrayList(categoryMap.values());
        this.sortNormally(LegendComparators.CASE_SENSITIVE_ORDER);
    }

    private void initIconListFromCategoryList() {
        this.icon_list = new ArrayList(this.objdef_list.size());
        for (Category category : this.objdef_list) {
            CategoryIcon categoryIcon = new CategoryIcon(category);
            this.icon_list.add(categoryIcon);
        }
    }

    private void sortNormally(Comparator comparator) {
        Collections.sort(this.objdef_list, comparator);
        this.initIconListFromCategoryList();
    }

    private void sortReversely(Comparator comparator) {
        Collections.sort(this.objdef_list, comparator);
        Collections.reverse(this.objdef_list);
        this.initIconListFromCategoryList();
    }

    public void arrangeOrder(Comparator comparator) {
        this.sortNormally(comparator);
        super.fireTableDataChanged();
    }

    public void reverseOrder(Comparator comparator) {
        this.sortReversely(comparator);
        super.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.objdef_list.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_TITLES.length;
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES[n];
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_TITLES[n];
    }

    public Color getColumnNameForeground(int n) {
        return COLUMN_TITLE_FORE_COLORS[n];
    }

    public Color getColumnNameBackground(int n) {
        return COLUMN_TITLE_BACK_COLORS[n];
    }

    public boolean isRaisedColumnNameIcon(int n) {
        return COLUMN_TITLE_RAISED_ICONS[n];
    }

    public String getColumnToolTip(int n) {
        return COLUMN_TOOLTIPS[n];
    }

    public Object getColumnMaxValue(int n) {
        switch (n) {
            case 0: {
                return CategoryIcon.BLANK_ICON;
            }
            case 1: {
                Category category = (Category)Collections.max(this.objdef_list, LegendComparators.LONG_NAME_ORDER);
                return category.getName().toUpperCase() + ".";
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 3: {
                return Boolean.TRUE;
            }
            case 4: {
                Category category = (Category)Collections.max(this.objdef_list, LegendComparators.COUNT_ORDER);
                return new Long(category.getSummary().getDrawableCount() * 10L);
            }
            case 5: {
                Category category = (Category)Collections.max(this.objdef_list, LegendComparators.INCL_RATIO_ORDER);
                return new Float(category.getSummary().getRatio(true) * 10.0f);
            }
            case 6: {
                Category category = (Category)Collections.max(this.objdef_list, LegendComparators.EXCL_RATIO_ORDER);
                return new Float(category.getSummary().getRatio(false) * 10.0f);
            }
        }
        System.err.println("LegendTableModel.getColumnMaxValue(" + n + ") fails!");
        return null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.icon_list.get(n);
            }
            case 1: {
                Category category = (Category)this.objdef_list.get(n);
                return category.getName();
            }
            case 2: {
                Category category = (Category)this.objdef_list.get(n);
                if (category.isVisible()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 3: {
                Category category = (Category)this.objdef_list.get(n);
                if (category.isSearchable()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 4: {
                Category category = (Category)this.objdef_list.get(n);
                return new Long(category.getSummary().getDrawableCount());
            }
            case 5: {
                Category category = (Category)this.objdef_list.get(n);
                return new Float(category.getSummary().getRatio(true));
            }
            case 6: {
                Category category = (Category)this.objdef_list.get(n);
                return new Float(category.getSummary().getRatio(false));
            }
        }
        System.err.println("LegendTableModel.getValueAt(" + n + "," + n2 + ") fails!");
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Category category = (Category)this.objdef_list.get(n);
        switch (n2) {
            case 0: {
                ColorAlpha colorAlpha = (ColorAlpha)object;
                category.setColor(colorAlpha);
                CategoryIcon categoryIcon = (CategoryIcon)this.icon_list.get(n);
                categoryIcon.setDisplayedColor(colorAlpha);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 1: {
                category.setName((String)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 2: {
                category.setVisible((Boolean)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 3: {
                category.setSearchable((Boolean)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                System.err.print("LegendTableModel.setValueAt(" + n + "," + n2 + ") fails!");
            }
        }
    }
}

