/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.ColorAlpha;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import viewer.legends.CategoryIcon;

public class CategoryIconEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = 2200L;
    private JButton delegate_btn = new JButton();
    private ColorAlpha saved_color;
    private Color prev_color;

    public CategoryIconEditor() {
        super(new JCheckBox());
        this.delegate_btn.addActionListener(this);
        this.editorComponent = this.delegate_btn;
        super.setClickCountToStart(1);
        this.saved_color = null;
        this.prev_color = null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        CategoryIcon categoryIcon = (CategoryIcon)object;
        this.prev_color = categoryIcon.getDisplayedColor();
        this.delegate_btn.setIcon(categoryIcon);
        return this.delegate_btn;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this.delegate_btn, "Pick a Color", this.prev_color);
        this.saved_color = color != null ? new ColorAlpha(color, 255) : new ColorAlpha(this.prev_color, 255);
        this.fireEditingStopped();
    }

    @Override
    public Object getCellEditorValue() {
        return this.saved_color;
    }
}

