/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.CategoryRatios;
import base.drawable.CategorySummary;
import java.util.Comparator;

public class CategorySummaryF
extends CategoryRatios {
    public static final int BYTESIZE = 16;
    public static final Comparator COUNT_ORDER = new CountOrder();
    private double num_real_objs;

    public CategorySummaryF() {
        this.num_real_objs = 0.0;
    }

    public CategorySummaryF(float f, float f2, double d) {
        super(f, f2);
        this.num_real_objs = d;
    }

    public CategorySummaryF(CategorySummaryF categorySummaryF) {
        super(categorySummaryF);
        this.num_real_objs = categorySummaryF.num_real_objs;
    }

    public CategorySummaryF(CategorySummary categorySummary) {
        super(categorySummary);
        this.num_real_objs = categorySummary.getDrawableCount();
    }

    public double getDrawableCount() {
        return this.num_real_objs;
    }

    public void addDrawableCount(double d) {
        this.num_real_objs += d;
    }

    public void rescaleDrawableCount(double d) {
        this.num_real_objs *= d;
    }

    @Override
    public String toInfoBoxString(int n) {
        return super.toInfoBoxString(n) + ", count=" + (float)this.num_real_objs;
    }

    @Override
    public String toString() {
        return super.toString() + ", count=" + (float)this.num_real_objs;
    }

    private static class CountOrder
    implements Comparator {
        private CountOrder() {
        }

        public int compare(Object object, Object object2) {
            CategorySummaryF categorySummaryF = (CategorySummaryF)object;
            CategorySummaryF categorySummaryF2 = (CategorySummaryF)object2;
            double d = categorySummaryF.num_real_objs - categorySummaryF2.num_real_objs;
            return d < 0.0 ? -1 : (d == 0.0 ? 0 : 1);
        }
    }
}

