/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import viewer.common.Routines;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.OperationDurationPanel;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.SummarizableView;
import viewer.zoomable.TimeFormat;

public class InfoDialogForDuration
extends InfoDialog {
    private static final String FORMAT = "#,##0.000000####";
    private static DecimalFormat fmt = null;
    private static TimeFormat tfmt = null;
    private TimeBoundingBox timebox;
    private ScrollableObject scrollable;

    public InfoDialogForDuration(Frame frame, TimeBoundingBox timeBoundingBox, ScrollableObject scrollableObject) {
        super(frame, "Duration Info Box", timeBoundingBox.getLatestTime());
        this.timebox = timeBoundingBox;
        this.scrollable = scrollableObject;
        this.init();
    }

    public InfoDialogForDuration(Dialog dialog, TimeBoundingBox timeBoundingBox, ScrollableObject scrollableObject) {
        super(dialog, "Duration Info Box", timeBoundingBox.getLatestTime());
        this.timebox = timeBoundingBox;
        this.scrollable = scrollableObject;
        this.init();
    }

    private void init() {
        if (fmt == null) {
            fmt = (DecimalFormat)NumberFormat.getInstance();
            fmt.applyPattern(FORMAT);
        }
        if (tfmt == null) {
            tfmt = new TimeFormat();
        }
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 3;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("duration = " + tfmt.format(this.timebox.getDuration()));
        n = stringBuffer2.length();
        stringBuffer.append(stringBuffer2.toString() + "\n");
        stringBuffer2 = new StringBuffer();
        stringBuffer2.append("[0]: time = " + fmt.format(this.timebox.getEarliestTime()));
        if (n < stringBuffer2.length()) {
            n = stringBuffer2.length();
        }
        stringBuffer.append(stringBuffer2.toString() + "\n");
        stringBuffer2 = new StringBuffer();
        stringBuffer2.append("[1]: time = " + fmt.format(this.timebox.getLatestTime()));
        if (n < stringBuffer2.length()) {
            n = stringBuffer2.length();
        }
        stringBuffer.append(stringBuffer2.toString());
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        int n3 = Routines.getAdjNumOfTextColumns(jTextArea, n);
        jTextArea.setColumns(n3);
        jTextArea.setRows(n2);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setAlignmentX(0.0f);
        container.add(jScrollPane);
        if (this.scrollable instanceof SummarizableView) {
            SummarizableView summarizableView = (SummarizableView)((Object)this.scrollable);
            OperationDurationPanel operationDurationPanel = new OperationDurationPanel(this.timebox, summarizableView);
            operationDurationPanel.setAlignmentX(0.0f);
            container.add(operationDurationPanel);
        }
        container.add(super.getCloseButtonPanel());
    }

    public TimeBoundingBox getTimeBoundingBox() {
        return this.timebox;
    }
}

