/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalButtonListener;

public class MetalButtonUI
extends BasicButtonUI {
    private static final MetalButtonUI metalButtonUI = new MetalButtonUI();
    private boolean defaults_initialized = false;
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new MetalButtonListener(abstractButton);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return metalButtonUI;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.focusColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "focus");
            this.selectColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "select");
            this.disabledTextColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "disabledText");
            this.defaults_initialized = true;
        }
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        boolean bl;
        Rectangle rectangle4 = new Rectangle();
        String string = abstractButton.getText();
        boolean bl2 = bl = abstractButton.getIcon() != null;
        if (string != null && !string.equals("")) {
            if (!bl) {
                rectangle4.setBounds(rectangle2);
            } else {
                rectangle4.setBounds(rectangle3.union(rectangle2));
            }
        } else if (bl) {
            rectangle4.setBounds(rectangle3);
        }
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.getDisabledTextColor());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }
}

