/***************************************************************************
                          mydb.cpp  -  description
                             -------------------
    begin                : Tue Feb 13 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <qfileinfo.h>

#include <iostream.h>

#include <stdlib.h>
#include <mysql/mysql.h>
#include "mydb.h"
#include "ogginfo.h"
#include "mp3info.h"
#include "fileinfo.h"
#include "utils.h"

MYSQL mysql;
MYSQL_RES *res;
MYSQL_ROW row;

MyDb::MyDb ()
{
     res=NULL;
   /*  mysql_init(&mysql);
     if (!(mysql_real_connect(&mysql, "localhost", "mp3kult", "mp3kult",
          "Mp3Kult", 0, NULL, 0 )))
          exiterr(1);  */
    /* if (!(mysql_connect(&mysql, "localhost", "mp3kult", "mp3kult")))
          exiterr(1);
     if (mysql_select_db(&mysql, "Mp3Kult"))
          exiterr(2);       */
}

MyDb::~MyDb ()
{
     mysql_free_result(res);
     mysql_close(&mysql);
}

bool MyDb::dbConnect( const char* host, const char* user, const char* password,
                  const char* database)
{

  cerr << "Try to connect" << endl;
  if ((!mysql_connect(&mysql, host, user, password)))
  {
    cerr << mysql_error(&mysql) << endl;
    return false;
  }
  cerr << "Connected" << endl;

  if (mysql_select_db(&mysql,database))
  {
    cerr << mysql_error(&mysql) << endl;
    return false;
  }
  cerr << "Database found" << endl;
  return true;

}

bool MyDb::dbCreate (const char* host, const char* user, const char* password,
										const char* database, const char* adminpass, const char* adminuser)
{
	char buf[4096];
	cerr << "Start database creation" << endl;
	if (QString (adminpass).isEmpty())
	{
		if ((!mysql_connect(&mysql, host, adminuser, "")))
  	{
    	cerr << mysql_error(&mysql) << " --> Admin Name incorrect" <<endl;
    	return false;
  	}
	}
	else
	{
		if ((!mysql_connect(&mysql, host, adminuser, adminpass)))
  	{
    	cerr << mysql_error(&mysql) << " --> Admin Name or Password incorrect" << endl;
    	return false;
  	}
  	cerr << "Connected" << endl;
	}
	sprintf (buf, "CREATE DATABASE %s", insbslash(database));
	if (mysql_query(&mysql, buf))
	{
		cerr << mysql_error(&mysql) << " --> Error creating the DataBase" << endl;
		return false;
	}

	if (mysql_select_db(&mysql,database))
  {
    cerr << mysql_error(&mysql) << " --> Error connecting to DataBase" << endl;
    return false;
  }

	sprintf (buf, "CREATE TABLE Mp3s (Mp3id MEDIUMINT UNSIGNED PRIMARY KEY AUTO_INCREMENT, Title"
								" VARCHAR(100) NOT NULL, Artist VARCHAR(100) NOT NULL, Album VARCHAR(100)"
								" NOT NULL, Genre TINYINT UNSIGNED,Year CHAR(4), Comment VARCHAR(100),"
								" Length INTEGER, Path TEXT NOT NULL, Name TEXT NOT NULL,"
								" Volume VARCHAR(40), Size INTEGER NOT NULL, Mode TINYINT UNSIGNED,"
								" Bitrate SMALLINT NOT NULL, Sample INTEGER NOT NULL, Track VARCHAR(10))");
	if (mysql_query(&mysql, buf))
	{
		cerr << mysql_error(&mysql) << " --> Error creating Mp3s Table" << endl;
		return false;
	}

	sprintf (buf, "CREATE TABLE Playlists (Entryid MEDIUMINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,"
								" Song VARCHAR(210) NOT NULL, Length INTEGER, Volume VARCHAR(40),"
								" Plname VARCHAR(50), File TEXT NOT NULL, Mp3id MEDIUMINT UNSIGNED,"
								" Ord INTEGER NOT NULL)");

	if (mysql_query(&mysql, buf))
	{
		cerr << mysql_error(&mysql) << " --> Error creating Playlists Table" << endl;
		return false;
	}

	sprintf (buf, "GRANT SELECT,INSERT,UPDATE,DELETE,CREATE,DROP ON %s.* TO"
						" %s@%s IDENTIFIED BY \'%s\'", database, user, host, password);

	if (mysql_query(&mysql, buf))
	{
		cerr << mysql_error(&mysql) << " --> Error inserting Grant Privileges" << endl;
		return false;
	}

	 mysql_close(&mysql);

	 cerr << "Creation successfull" << endl;
	 return true;
}


// Add a new mp3 in the db, this function is also called (directly) by
// addmp3 function in mp3kult.cpp file

bool MyDb::addEntry (const char* file, const char* volume, int type)
{
     /*mp3tag tag(file);*/
     //FileInfo info(file);
		// Ogg info(file);
		FileInfo * info;
     char buf[4096];
     QString filename, title, artist, album/*, ext*/;
		 //QFileInfo filet(file);
		 //int fileType = -1;


	if ((info = Utils::createInfo(file))== NULL)
		return false;
/*	ext = filet.extension(false);

	if (ext.contains("mp3", false) > 0)
	{
		//FileInfo info(file);
		cerr << "Mp3 !!" << endl;
		info = new Mp3Info(file);
		fileType = 0;
	}
	else if (ext.contains("ogg", false) > 0)
	{
		//Ogg info(file);
		cerr << "Ogg !!" << endl;
		info = new OggInfo(file);
		fileType = 1;
	}
	else
		return false;*/

	/*if (!(info.getResult()))
		return false;

     filename = info.getName();
     title =  info.getTitle();
     artist =  info.getArtist();
     album = info.getAlbum();
     //if tag is empty, gets info from file name
     elabInfo(artist, title, album, filename, type);

     sprintf (buf, "INSERT INTO Mp3s (Title, Artist, Album, Genre, Year,"
               "Comment, Length, Path, Name, Volume, Size, Mode, Bitrate,"
               "Sample, Track) VALUES (\"%s\", \"%s\", \"%s\", %i, \"%s\", "
               "\"%s\", %i, \"%s\", \"%s\", \"%s\", %i, %i, %i, %i, \"%s\")",
               insbslash(title), insbslash(artist),
               insbslash(album), info.getGenre(), info.getYear(),
               insbslash(info.getComment()), info.getLength(),
               insbslash(info.getPath()), insbslash(filename),
               insbslash(volume), info.getSize(), info.getMode(),
               info.getBitrate(), info.getSamplerate(), info.getTrack());*/

							 if (!(info->getResult()))
							 {
							 cerr << "not result" << endl;
		return false;
		}

     filename = info->getName();
     title =  info->getTitle();
     artist =  info->getArtist();
     album = info->getAlbum();
     //if tag is empty, gets info from file name
     elabInfo(artist, title, album, filename, type);

     sprintf (buf, "INSERT INTO Mp3s (Title, Artist, Album, Genre, Year,"
               "Comment, Length, Path, Name, Volume, Size, Mode, Bitrate,"
               "Sample, Track) VALUES (\"%s\", \"%s\", \"%s\", %i, \"%s\", "
               "\"%s\", %i, \"%s\", \"%s\", \"%s\", %i, %i, %i, %i, \"%s\")",
               insbslash(title), insbslash(artist),
               insbslash(album), info->getGenre(), info->getYear(),
               insbslash(info->getComment()), info->getLength(),
               insbslash(info->getPath()), insbslash(filename),
               insbslash(volume), info->getSize(), info->getMode(),
               info->getBitrate(), info->getSamplerate(), info->getTrack());

     if (mysql_query(&mysql, buf))
     {
          cerr << "Error inserting mp3" << endl;
          exiterr(10);
     }
		 delete info;
     return true;
}

void MyDb::updateTag(const char* file, int id, int type)
{
     FileInfo *info;
		// Mp3Info info(file);
     char buf[4096];
     QString filename, title, artist, album;

	if ((info = Utils::createInfo(file))== NULL)
	{
		cerr << "MyDb::updateTag --> Error updating tag: " << file<< endl;
		return;
	}

     if (!(info->getResult()))
          return;

     filename = info->getName();
     title =  info->getTitle();
     artist =  info->getArtist();
     album = info->getAlbum();
     //if tag is empty, gets info from file name
     elabInfo(artist, title, album, filename, type);

     sprintf (buf, "UPDATE Mp3s SET Title=\"%s\", Artist=\"%s\", Album=\"%s\","
                "Genre=%i, Year=\"%s\",Comment=\"%s\", Track=\"%s\" WHERE Mp3id = %i",
               insbslash(title), insbslash(artist),
               insbslash(album), info->getGenre(), info->getYear(),
               insbslash(info->getComment()), info->getTrack(), id);

     if (mysql_query(&mysql, buf))
     {
          cerr << "Error inserting mp3: " << filename << endl;
          exiterr(10);
     }
		 delete info;
}

const char* MyDb::insbslash(const char* str)
{
     if (str == NULL)
          return str;
     QString tmp (str);
     for (uint i=0; i < tmp.length(); i++)
     {
          if ((tmp[i] == '\'' || tmp[i] =='\"' || tmp[i] == '\\') /*&& tmp[i-1] != '\\'*/)
          {
               tmp.insert (i,'\\');
               i++;
          }
     }
     return strdup (tmp);
}

// Removes selected volume from db

int MyDb::delVolume (const char* volume)
{
     char buf[256];

     sprintf (buf, "DELETE FROM Mp3s WHERE Volume = \'%s\'", insbslash(volume));
     if (mysql_query (&mysql, buf))
          exiterr(9);
     return (mysql_affected_rows(&mysql));
}

void MyDb::exiterr(int num)
{
     cerr << mysql_error(&mysql);
     exit (num);
}

void MyDb::addVolume (const char* dir, bool recursive, const char* volume, int type)
{
     QDir d(dir);
     if (!(d.isReadable()))
     {
          cerr << "Directory not readable: " << dir << endl;
          return;
     }
  /*   d.setFilter (QDir::Dirs);
     d.setSorting (QDir::Name);   */

     const QFileInfoList *list;/* =d.entryInfoList();*/
 /*    QFileInfoListIterator it (*list);*/
     QFileInfo *fi;

     // If recursive, enters in all directories (recursivement)
     // One function for each directory

     if (recursive)
     {
          list = d.entryInfoList(QDir::Dirs, QDir::Name);
          QFileInfoListIterator it (*list);

          while ( (fi=it.current()) )
          {
               if (strcmp(fi->fileName(), ".") && strcmp(fi->fileName(), ".."))
                    addVolume (fi->absFilePath() , recursive, volume, type);
               ++it;
           }
     }
    /* QDir f(dir);
     d.setFilter (QDir::Files);
     d.setSorting (QDir::Name);       */

     // For each directory makes a list of files

     list =d.entryInfoList("*.??3;*.ogg", QDir::Files, QDir::Name);
     QFileInfoListIterator itf (*list);

     while ( (fi=itf.current()) )
     {
         addEntry (fi->absFilePath(), volume, type);
          ++itf;
     }
}

// Gets all informations from db, for initialization of mp3 list

int MyDb::getAll()
{
     char buf[256];
     sprintf (buf, "SELECT * FROM Mp3s ORDER BY Volume ASC");
     if (mysql_query (&mysql, buf))
          exiterr(9);
     res = mysql_store_result(&mysql);
     return (mysql_num_rows(res));
}

int MyDb::getVolume(const char* volname)
{
    char buf[256];
    sprintf (buf, "SELECT * FROM Mp3s WHERE Volume = \"%s\"",
            insbslash(volname));
    if (mysql_query (&mysql, buf))
        exiterr(9);
    res = mysql_store_result(&mysql);
    return (mysql_num_rows(res));
}

void MyDb::delAll()
{
     char buf[256];
     sprintf (buf, "DELETE FROM Mp3s");
     if (mysql_query (&mysql, buf))
          exiterr(10);
}

int MyDb::getNumres()
{
     return (mysql_num_rows(res));
}

MYSQL_ROW MyDb::getRow()
{
  return (mysql_fetch_row (res));
}

void MyDb::freeRes ()
{
     mysql_free_result(res);
}

// Rescans all paths of volume, deletes old volume and creates a new archive
// Return number of entries of old volume

int MyDb::updateVolume (const char* volname, int type)
{
     char buf[256];
     int num = 0;
     MYSQL_RES *restmp;
     MYSQL_ROW rowtmp;

     // Finds all distinct paths
     sprintf (buf, "SELECT DISTINCT Path FROM Mp3s WHERE Volume = \'%s\'",
               insbslash(volname));
     if(mysql_query(&mysql, buf))
          exiterr(12);
     restmp = mysql_store_result(&mysql);

     // For each path: deletes all antries with this path and volume name
     // and rescans this directory
     while ((rowtmp = mysql_fetch_row(restmp)))
     {
          sprintf (buf, "DELETE FROM Mp3s WHERE Volume = \'%s\' AND Path=\'%s\'",
                    insbslash(volname), insbslash(rowtmp[0]));
          if(mysql_query(&mysql, buf))
               exiterr(13);
          num += mysql_affected_rows(&mysql);

          QDir dir(rowtmp[0]);
          if (dir.exists())
               addVolume (rowtmp[0], false, volname, type);
     }
     mysql_free_result(restmp);
     return num;
}

int MyDb::renameVolume (const char* newname, const char* oldname)
{
	char buf[256];

	sprintf (buf, "UPDATE Playlists set Volume = \'%s\' WHERE Volume = \'%s\'",
						insbslash(newname), insbslash(oldname));
	if(mysql_query(&mysql, buf))
		exiterr(13);

	sprintf (buf, "UPDATE Mp3s set Volume = \'%s\' WHERE Volume = \'%s\'",
						insbslash(newname), insbslash(oldname));
	if(mysql_query(&mysql, buf))
		exiterr(13);
	cerr << "Updated : " << mysql_affected_rows(&mysql) << " Mp3s" << endl;

	return mysql_affected_rows(&mysql);
}


// gets names of volumes

int MyDb::getVolname(const char* mod)
{
     char buf[256];

     sprintf (buf, "SELECT DISTINCT Volume FROM Mp3s ORDER BY Volume %s", mod);
     if(mysql_query(&mysql, buf))
          exiterr(13);
     res = mysql_store_result(&mysql);
     return (mysql_num_rows(res));
}

void MyDb::delMp3(const char* name, const char* path, const int size)
{
     char buf[256];
     sprintf (buf, "DELETE FROM Mp3s WHERE Path = \'%s\' AND Name = \'%s\' "
                    "AND Size = %i", insbslash(path), insbslash(name), size);
     if (mysql_query(&mysql, buf))
          exiterr(14);
}

// return the last entry insert

void MyDb::getLastInsert()
{
     int id;
     char buf[256];

     id = mysql_insert_id(&mysql);
     sprintf (buf, "SELECT * FROM Mp3s WHERE Mp3id = %d", id);
     if(mysql_query(&mysql, buf))
          exiterr(13);
     res = mysql_store_result(&mysql);
}

void MyDb::getMp3(int id)
{
     char buf[256];

     sprintf (buf, "SELECT * FROM Mp3s WHERE Mp3id = %d", id);
     if(mysql_query(&mysql, buf))
          exiterr(13);
     res = mysql_store_result(&mysql);

}


int MyDb::getMp3(const char* fname, const char* path )
{
  char buf[256];

  if (path)
  {
     sprintf (buf, "SELECT * FROM Mp3s WHERE Name = \"%s\" AND Path = \"%s\"",
              insbslash (fname), insbslash(path));
  }
  else
  {
    sprintf (buf, "SELECT * FROM Mp3s WHERE Name = \"%s\"" ,
              insbslash (fname));
  }

  if(mysql_query(&mysql, buf))
    exiterr(13);
  res = mysql_store_result(&mysql);
  return (mysql_num_rows(res));
}


void MyDb::elabInfo (QString& artist, QString& title, QString& album,
                              const QString file, int type)
{
    int length, ind, indArt,indArt2, indTit, indTit2, indAlb, indAlb2, lenMid;
    QString artistTmp, titleTmp, albumTmp;
    // If Mp3Tag contains Title information, quits function

    if ((!title.isEmpty()) && (!artist.isEmpty()) && (!album.isEmpty()))
        return;
    QString tmp = file;

    length = tmp.length();
    length = length-4;

    // if the last characters are white spaces, it truncates them
    while (tmp[length] == ' ')
        length--;
    tmp.truncate(length);

    switch (type){

        case 0:          /*none*/
            titleTmp = tmp;
            titleTmp.truncate(100);
            titleTmp[0] = titleTmp[0].upper();
            break;

        case 1:         /*Artist - Title.mp3*/
            if ((!title.isEmpty()) && (!artist.isEmpty()))
                return;
                /*should work with file like Artist - **** -Title.mp3*/
            ind = tmp.find('-');
            if (ind == -1)
                break;
            // indArt could be different from indTitle
            //example Guns n' Roses - Use your illusion I - November rain.mp3
            indArt=ind;
            // Finds indTit ('-' position)  from the last character
            indTit = tmp.findRev('-');
            //Eats white spaces
            while (tmp[indArt-1] == ' ' && indArt > 0)
                indArt--;
            //artist = all of the characters to left of indArt index
            artistTmp = tmp.left(indArt);
            // truncates artist to 30 char, must change itfor mp3tag v2.0
            // Max length for Artist Album ... in Tag v1.X is 30 !
            artistTmp.truncate(100);
            artistTmp[0]=artistTmp[0].upper();

            while (tmp[indTit+1] == ' ' && indTit < length)
                indTit++;

            indTit = length - indTit - 1;
            titleTmp = tmp.right(indTit);
            titleTmp.truncate(100);
            titleTmp[0]=titleTmp[0].upper();

            cerr << "case 1: Artist: " << artistTmp << " Title: " << titleTmp << endl;
            break;

        case 2:           /*Title - Artist.mp3*/
            if ((!title.isEmpty()) && (!artist.isEmpty()))
                return;
            ind = tmp.find('-');
            if (ind == -1)
                break;
            indTit=ind;
            indArt= tmp.findRev('-');
            while (tmp[indTit-1] == ' ' && indTit > 0)
                indTit--;
            titleTmp = tmp.left(indTit);
            titleTmp.truncate(100);
            titleTmp[0]=titleTmp[0].upper();

            while (tmp[indArt+1] == ' ' && indArt < length)
                indArt++;
            indArt = length - indArt - 1;
            artistTmp = tmp.right(indArt);
            artistTmp.truncate(100);
            artistTmp[0]=artistTmp[0].upper();

            cerr << "case 2: Artist: " << artistTmp << " Title: " << titleTmp << endl;
            break;

        case 3:               /*Title (Artist).mp3*/
            if ((!title.isEmpty()) && (!artist.isEmpty()))
                return;
            ind = tmp.findRev('(');
            if (ind == -1)
                break;
            indArt=indTit=ind;

            indArt2 = tmp.findRev(')');
            if (indArt2 > -1)
            {
                while (tmp[indArt2-1] == ' ' && indArt2 > indArt)
                    indArt2--;
                tmp.truncate(indArt2);
                length = tmp.length();
            }

            // cerr << "Tmp " << tmp << endl;

            while (tmp[indArt+1] == ' ' && indArt < length)
                indArt++;
            indArt = length - indArt - 1;
            artistTmp = tmp.right(indArt);
            artistTmp.truncate(100);
            artistTmp[0]=artistTmp[0].upper();

            while (tmp[indTit-1] == ' ' && indTit > 0)
                indTit--;
            titleTmp = tmp.left(indTit);
            titleTmp.truncate(100);
            titleTmp[0]=titleTmp[0].upper();

            cerr << "case 3: Artist: " << artistTmp << " Title: " << titleTmp << endl;
            break;

       case 4:           /*Title - Album.mp3*/
            if ((!title.isEmpty()) && (!album.isEmpty()))
                return;
            ind = tmp.find('-');
            if (ind == -1)
                break;
            indTit=ind;
            indAlb= tmp.findRev('-');
            while (tmp[indTit-1] == ' ' && indTit > 0)
                indTit--;
            titleTmp = tmp.left(indTit);
            titleTmp.truncate(100);
            titleTmp[0]=titleTmp[0].upper();

            while (tmp[indAlb+1] == ' ' && indAlb < length)
                indAlb++;
            indAlb = length - indAlb - 1;
            albumTmp = tmp.right(indAlb);
            albumTmp.truncate(100);
            albumTmp[0]=albumTmp[0].upper();

            cerr << "case 4: Album: " << albumTmp << " Title: " << titleTmp << endl;
            break;

        case 5:   //artist-album-song.mp3
            ind = tmp.find('-');
            if (ind == -1)
                break;

            indArt=indAlb=ind;
            indTit = indAlb2 = tmp.findRev('-');

            while (tmp[indArt-1] == ' ' && indArt > 0)
                indArt--;

            artistTmp = tmp.left(indArt);
            artistTmp.truncate(100);
            artistTmp[0]=artistTmp[0].upper();

            while (tmp[indTit+1] == ' ' && indTit < length)
                indTit++;

            indTit = length - indTit - 1;
            titleTmp = tmp.right(indTit);
            titleTmp.truncate(100);
            titleTmp[0]=titleTmp[0].upper();

            while (tmp[indAlb+1] == ' ' && indAlb < length)
                indAlb++;
            while (tmp[indAlb2-1] == ' ' && indAlb2 < length)
                indAlb2--;

            lenMid = indAlb2 - indAlb;

            albumTmp = tmp.mid (indAlb+1, lenMid);
            albumTmp.truncate(100);
            albumTmp[0]=albumTmp[0].upper();

            cerr << "case 5: Artist: " << artistTmp << " Title: " << titleTmp << " Album " << albumTmp << endl;
            break;

        case 6:        //artist-song-album.mp3
            ind = tmp.find('-');
            if (ind == -1)
                break;

            indArt=indTit=ind;
            indAlb= indTit2 = tmp.findRev('-');

            while (tmp[indArt-1] == ' ' && indArt > 0)
                indArt--;

            artistTmp = tmp.left(indArt);
            artistTmp.truncate(100);
            artistTmp[0]=artistTmp[0].upper();

            while (tmp[indAlb+1] == ' ' && indAlb < length)
                indAlb++;

            indAlb = length - indAlb - 1;
            albumTmp = tmp.right(indAlb);
            albumTmp.truncate(100);
            albumTmp[0]=albumTmp[0].upper();

            while (tmp[indTit+1] == ' ' && indTit < length)
                indTit++;
            while (tmp[indTit2-1] == ' ' && indTit2 < length)
                indTit2--;

            lenMid = indTit2 - indTit;

            titleTmp = tmp.mid (indTit+1, lenMid);
            titleTmp.truncate(100);
            titleTmp[0]=titleTmp[0].upper();

            cerr << "case 6: Artist: " << artistTmp << " Title: " << titleTmp << " Album " << albumTmp << endl;
            break;
    }

    if (title.isEmpty())
    {
        if (!(titleTmp.isEmpty()))
            title = titleTmp;
        else
        {
            title = tmp;
            title.truncate(100);
            title[0] = title[0].upper();
        }
     }
     if (artist.isEmpty() && !(artistTmp.isEmpty()))
        artist = artistTmp;
     if (album.isEmpty() && !(albumTmp.isEmpty()))
        album = albumTmp;
}

// Gets all names of playlists

int MyDb::getPLName(const char* mod)
{
     char buf[256];
     sprintf (buf, "SELECT DISTINCT Plname FROM Playlists ORDER BY Plname %s", mod);
     if(mysql_query(&mysql, buf))
          exiterr(13);
     res = mysql_store_result(&mysql);
     return (mysql_num_rows(res));
}

int MyDb::getPL(const char* name, const char* ord, const char* mod)
{
     char buf[256];
     sprintf (buf, "SELECT * FROM Playlists WHERE Plname = \'%s\' "
                    "ORDER BY %s %s", name, ord, mod);
     if(mysql_query(&mysql, buf))
          exiterr(16);
     res = mysql_store_result(&mysql);
     return (mysql_num_rows(res));
}

void MyDb::addEntryPL(const char* song, int length, const char* volume,
                    const char* name, const char* file, int mp3id, int order)
{
     char buf[4096];
     sprintf (buf, "INSERT INTO Playlists (Song, Length, Volume, Plname, "
                    "File, Mp3id, Ord) VALUES (\"%s\", %i, "
                    "\"%s\", \"%s\", \"%s\", %d, %d)", insbslash(song),
                    length, insbslash(volume), insbslash(name),
                    insbslash(file), mp3id, order);
    if (mysql_query(&mysql, buf))
          exiterr(10);
}

void MyDb::delPL(const char* name)
{
     char buf[256];
     sprintf (buf, "DELETE FROM Playlists WHERE Plname = \'%s\'",
               insbslash(name));
     if (mysql_query(&mysql, buf))
          exiterr(12);
}

void MyDb::renamePL (const char* newname, const char* oldname)
{
	char buf[256];
	sprintf (buf, "UPDATE Playlists set Plname = \'%s\' WHERE Plname = \'%s\'",
						insbslash(newname), insbslash(oldname));
	if(mysql_query(&mysql, buf))
		exiterr(13);
}

