
/*
 * @(#)callbacks.h 1.2 01/01/18
 *
 * Copyright (c) Rich Burridge. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MPTOOL_CALLBACKS_H__
#define __MPTOOL_CALLBACKS_H__

#include <gtk/gtk.h>


void
ShowFile (GtkMenuItem *menuitem,
          gpointer user_data);

void
ExitMptool (GtkMenuItem *menuitem,
            gpointer user_data);

void
ShowHeaders (GtkMenuItem *menuitem,
             gpointer user_data);

void
ShowInput (GtkMenuItem *menuitem,
           gpointer user_data);

void
ShowOutput (GtkMenuItem *menuitem,
            gpointer user_data);

void
ShowPrinting (GtkMenuItem *menuitem,
              gpointer user_data);

void
SaveDefaults (GtkMenuItem *menuitem,
              gpointer user_data);

void
ShowUsername (GtkMenuItem *menuitem,
              gpointer user_data);

void
HelpGeneral (GtkMenuItem *menuitem,
             gpointer user_data);

void
HelpHeaders (GtkMenuItem *menuitem,
             gpointer user_data);

void
HelpInput (GtkMenuItem *menuitem,
           gpointer user_data);

void
HelpOutput (GtkMenuItem *menuitem,
            gpointer user_data);

void
HelpPrinting (GtkMenuItem *menuitem,
              gpointer user_data);

void
HelpSave (GtkMenuItem *menuitem,
          gpointer user_data);

void
HelpUsername (GtkMenuItem *menuitem,
              gpointer user_data);

void
OutputUpdate (GtkToggleButton *togglebutton,
              gpointer user_data);

void
PrintFiles (GtkButton *button,
            gpointer user_data);

void
ResetOptions (GtkButton *button,
              gpointer user_data);

void
ToggleHdrList (GtkToggleButton *togglebutton,
               gpointer user_data);

void
HdrsAdd (GtkButton *button,
         gpointer user_data);

void
HdrsRemove (GtkButton *button,
            gpointer user_data);

void
HdrsApply (GtkButton *button,
           gpointer user_data);

void
HdrsReset (GtkButton *button,
           gpointer user_data);

void
HdrsDismiss (GtkButton *button,
             gpointer user_data);

void
InputApply (GtkButton *button,
            gpointer user_data);

void
InputReset (GtkButton *button,
            gpointer user_data);

void
InputDismiss (GtkButton *button,
              gpointer user_data);

void
OutputApply (GtkButton *button,
             gpointer user_data);

void
OutputReset (GtkButton *button,
             gpointer user_data);

void
OutputDismiss (GtkButton *button,
               gpointer user_data);

void
PrintingApply (GtkButton *button,
               gpointer user_data);

void
PrintingReset (GtkButton *button,
               gpointer user_data);

void
PrintingDismiss (GtkButton *button,
                 gpointer user_data);

void
UNApply (GtkButton *button,
         gpointer user_data);

void
UNReset (GtkButton *button,
         gpointer user_data);

void
UNDismiss (GtkButton *button,
           gpointer user_data);

void
HelpDismiss (GtkButton *button,
             gpointer user_data);

gboolean
dismiss_window (GtkWidget *widget,
                GdkEvent *event,
                gpointer user_data);

void
HeaderSelected (GtkList *list,
                GtkWidget *widget,
                gpointer user_data);

void
HeaderText (GtkEditable *editable,
            gpointer user_data);

void
HeaderUnselected (GtkList *list,
                  GtkWidget *widget,
                  gpointer user_data);

void
NoticeDismiss (GtkButton *button,
               gpointer user_data);

void
FileApply (GtkButton *button,
           gpointer user_data);

void
FileDismiss (GtkButton *button,
             gpointer user_data);

#endif /* __MPTOOL_CALLBACKS_H__ */
