
/*
 * @(#)lineopts.c 1.3 01/01/25
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Syntaxe pour le tableau d'arguments passe aux fonctions
 * iscoherent_com_line et usage (a mettre en static dans la procedure
 * principale par exemple...):
 * 
 * static char *arguments[]= { "Nom du programme", "argument obligatoire",
 * exemple: nom de fichier... : : "[argument optionnel]",
 * exemple: 2nd nom de fichier... : : "[arguments optionnels...]
 * ceci pour pouvoir mettre autant d'arguments optionnels que l'on veut...
 * 
 * : : "[-option]",                         exemple: -filofax ou "[-option
 * sous-option]",             exemple: -mode pyro ou "[-option
 * sous-option...]",          ceci pour pouvoir mettre plusieurs sous-options
 * d'affilee... : : NULL };
 */

#include "lineopts.h"
#include <ctype.h>
#include <stdlib.h>

/*
 * Convertit une chaine en minuscules. Retourne un pointeur sur la chaine
 * convertie...
 */

static char *
strtolower(char *src_str)
{
    char *tgt_str;
    int j;

    tgt_str = (char *) malloc(sizeof(char) * (strlen(src_str) + 1));
    for (j = 0; j < strlen(src_str); j++) {
        if (isupper((int) (*(src_str + j)))) {
            tgt_str[j] = (char) tolower((int) (*(src_str + j)));
        } else {
            tgt_str[j] = *(src_str + j);
        }
    }
    tgt_str[j] = '\0';

    return(tgt_str);
}


/*
 * Renvoie le numero d'un argument donne d'une ligne de commande s'il existe
 * dans cette ligne ... Dans le cas ou il existe plusieurs fois dans la
 * ligne, renvoie le numero de sa derniere occurence. Il n'y a que les
 * imbeciles qui ne changent pas d'avis...
 */

int 
getargnum(int nbarg, char **argtab, char *optstring, bool sensitive)
{
    int i;
    int argnum = False;
    char *arg, *opt_str;
    bool found;

    if (!sensitive) {
        opt_str = strtolower(optstring);
    } else {
        opt_str = optstring;
    }

    i = 1;
    found = False;

    while (i < nbarg) {
        if (!sensitive) {
            arg = strtolower(argtab[i]);
        } else {
            arg = argtab[i];
        }

        if (!strcmp(arg, opt_str)) {
            argnum = i;
            found = True;
        }
        i++;
    }
    if (found) {
        return(argnum);
    } else {
        return(False);
    }
}


/*             
 * Renvoie vrai si l'option subopt fait partie des sous-options de l'option
 * dont on a fourni le numero sur la ligne de commande...
 */

bool 
issuboption(int argc, char **argv, int optnum, char *subopt, bool sensitive)
{
    int i;
    char *arg, *subopt_str;

    if (!optnum) {
        return(False);
    }

    if (!sensitive) {
        subopt_str = strtolower(subopt);
    } else {
        subopt_str = subopt;
    }

    for (i = optnum + 1; (i < argc) && (!isoption(argv[i])); i++) {
        if (!sensitive) {
            arg = strtolower(argv[i]);
        } else {
            arg = argv[i];
        }
        if (!strcmp(subopt_str, arg)) {
            return(True);
        }
    }

    return(False);
}


/*
 * Renvoie Vrai si l'argument en question est une option...
 */

bool 
isoption(char *argument)
{
    if ((argument[0] == OPTIONID1) || (argument[0] == OPTIONID2)) {
        return(True);
    } else {
        return(False);
    }
}

static bool 
isoptional(char *argument)
{
    if (argument[0] == OPTIONALID) {
        return(True);
    } else {
        return(False);
    }
}


bool 
iscoherent_com_line(int nbarg, char **argtab, 
                    char **arguments, bool sensitive)
{
    bool found;
    int i, j, k = 0, n, nbpts;
    char *arg, *argument = NULL;

    i = 1;

    while ((arguments[i]) && (!isoptional(arguments[i]))) {
        if ((nbarg < i + 1) || (isoption(argtab[i]))) {
            return(False);
        }
        i++;
    }

    while ((nbarg > i) && (arguments[i]) && (!isoption(arguments[i] + 1)) &&
           (!isoption(argtab[i]))) {
        n = 1;
        found = False;
        argument = arguments[i];

        while ((*(argument + n) != OPTEND) && (*(argument + n) != EOS)) {
            if (*(argument + n) == POINT) {
                if (!strncmp(argument + n, ANDSO, 3)) {
                    found = True;
                    while ((nbarg > i) && (arguments[i]) && 
                           (!isoption(argtab[i]))) {
                        i++;
                    }
                    break;
                }
            }
            n++;
        }
        if (!found) {
            i++;
        }
    }

    while (i < nbarg) {
        if (!sensitive) {
            arg = strtolower(argtab[i]);
        } else {
            arg = argtab[i];
        }

        if (isoption(arg)) {
            found = False;
            j = 1;
            while ((arguments[j]) && (!found)) {
                if (!sensitive) {
                    argument = strtolower(arguments[j]);
                } else {
                    argument = arguments[j];
                }

                for (k = 1; (*(argument + k) != SPACE) && 
                            (*(argument + k) != EOS) && 
                            (*(argument + k) != OPTEND); k++) {
                    /* do nothing. */ ;
                }
                if ((strlen(arg) == k - 1) && 
                    (!strncmp(argument + 1, arg, k - 1))) {
                    found = True;
                }

                j++;
            }

            if (!found) {
                return(False);
            }

            while ((*(argument + k) != OPTEND) && (*(argument + k) != EOS)) {
                if (*(argument + k) == SPACE) {
                    if ((i < nbarg - 1) && (!isoption(argtab[i + 1]))) {
                        i++;
                    } else {
                        return (False);
                    }
                }

                if (*(argument + k) == POINT) {
                    nbpts = 0;
                    while (*(argument + k) == POINT) {
                        k++;
                        nbpts++;
                    }

                    if (nbpts == 3) {
                        while ((i < nbarg - 1) && (!isoption(argtab[i + 1]))) {
                            i++;
                        }
                    }
                } else {
                    k++;
                }
            }
        } else {
            return(False);
        }

        i++;
    }

    return(True);
}


void 
usage(char **arguments, char **comments)
{
    int i;

    FPRINTF(stderr, "Usage:");

    if (arguments) {
        for (i = 0; arguments[i]; i++) {
            FPRINTF(stderr, " %s\n\t\t", arguments[i]);
        }
    }

    FPRINTF(stderr, "\n");

    if (comments) {
        for (i = 0; comments[i]; i++) {
            FPRINTF(stderr, "%s\n", comments[i]);
        }
    }

    exit(1);
}
