/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const mgClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                          .getService(Components.interfaces.nsIClipboardHelper);

var mgWinMode = "mappingsWin";
var wType, mgTabBox, mapTree, mgCatLen, exportButton;
var sidebarMappings = new Array();
var scrollPositions = new Array();
var mgSelectedMapping = false;
var mgCanvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
mgCanvas.setAttribute("width", "32");
mgCanvas.setAttribute("height", "32");


function mgE(id) {
  return document.getElementById(id);
}

function mainInit() {
  window.removeEventListener("load", initMappingsWindow, false);
  mgMappingsObserver.register();

  mgTabBox = mgE("mozgestTabBox");
  mapTree = mgE("mozgestMappingsTree");
  mgCatLen = mgE("mapTreeChildren").childNodes.length;
  exportButton = mgE("exportButton");

  if (document.documentElement._buttons) {
    var extra2 = document.documentElement._buttons.extra2;
    extra2.setAttribute("type", "menu");
    extra2.appendChild(document.getElementById("setPopup"));
    extra2.label = mgCommon.getString("setButton");
    mgE("mgPublishCloseBtn").label = mgCommon.getString("closeButton");

    var cElts = mgE("mozgestSidebarContext").childNodes;

    for (var x = 0;x < cElts.length; x++) {
      if (!cElts[x].getAttribute("mozgestEditItem"))
        cElts[x].hidden = true;
    }
  }
  else {
    mgWinMode = "sideBar";
    mgE("editButtonsBox").hidden = true;
    mapTree.setAttribute("seltype", "single");
    mgTabBox.tabs.setAttribute("mozgestSideBarTabs", true);
  }

  for (each in _mgMS.supportedWindows)
    scrollPositions[each] = 0;

  mgTabBox.mgAllTabs = mgTabBox.tabs.cloneNode(true);
  initMappingsWindow();
  window.addEventListener("unload", function () {mgMappingsObserver.unregister()}, false);
}

function initMappingsWindow(rebuild, wt_old) {
  mgPrefs.init();
  mapTree.setAttribute("mozgestCanvas", mgPrefs["misc." + mgWinMode + ".canvas"]);

  //fill _mgMS.actTemp
  setActTemp();

  //readd all tabs
  if (rebuild) {
    while (mgTabBox.tabs.childNodes.length)
      mgTabBox.tabs.removeItemAt(0);

    for (var i = 0;i < mgTabBox.mgAllTabs.childNodes.length;i++)
      mgTabBox.tabs.appendChild(mgTabBox.mgAllTabs.childNodes[i].cloneNode(true));
  }

  //get window types supported by the app and select one
  var sW = document.getElementsByAttribute("mgWinType", "*");

  for (var y = 0; y < sW.length; y++) {
    var wt = sW[y].getAttribute("mgWinType");

    if (!(wt in _mgMS.supportedWindows) || !mgPrefs["window." + wt])
      sW[y].setAttribute("mgDummyTab", true);
  }

  var dummies = mgTabBox.tabs.getElementsByAttribute("mgDummyTab", "*");

  while (dummies.length)
    mgTabBox.tabs.removeChild(dummies[0]);

  if (!mgTabBox.tabs.itemCount) {
    mapTree.setAttribute("mozgestHide", true);

    if (mgWinMode == "mappingsWin")
      document.documentElement._buttons.cancel.focus();
  }

  if (mgWinMode == "mappingsWin") {
    mgE("editButtonsBox").hidden =
                         document.documentElement._buttons.extra2.hidden =
                         document.documentElement._buttons.accept.hidden =
                         (mgTabBox.tabs.itemCount) ? false : true;
  }

  mgTabBox._tabs.firstChild.removeAttribute("afterselected");

  if (!rebuild) {
    if (("arguments" in window)) {
      if (window.arguments[0]) {
        var args = window.arguments[0];
        var tab = document.getElementsByAttribute("mgWinType", args[1])[0]

        if (tab)
          mgTabBox.selectedTab = tab;
        else
          mgTabBox.selectedIndex = 0;

        if (args[0] == "directEdit" || args[0] == "Import")
          setTimeout(handleArguments, 0, args[0], args[2]);
      }
    }
    else
      mgTabBox.selectedIndex = 0;
  }
  else {
    var prevTab = document.getElementsByAttribute("mgWinType", wt_old)[0];

    if (prevTab)
      mgTabBox.selectedTab = prevTab;
    else
      mgTabBox.selectedIndex = 0;
  }
}

function setActTemp() {
  for (component in _mgMS.activeMappings) {
    _mgMS.actTemp[component] = new Array();
    sidebarMappings[component] = new Array();

    for (mapping in _mgMS.activeMappings[component]) {
      _mgMS.actTemp[component][mapping] = _mgMS.activeMappings[component][mapping];
      sidebarMappings[component][mapping] = _mgMS.activeMappings[component][mapping];
    }
  }
}

function restoreScroll() {
  if (mgE("mgScrollBox"))
    mgE("mgScrollBox").ensureElementIsVisible(mgTabBox.selectedTab);

  mapTree.currentIndex = -1;
  mapTree.treeBoxObject.scrollToRow(scrollPositions[wType]);
}

function showMappingsFor(component) {
  scrollPositions[wType] = mapTree.treeBoxObject.getFirstVisibleRow();
  mapTree.setAttribute("mozgestHide", true);
  wType = component;
  clearTree();
  sortTree(wType);

  var acm = (mgWinMode == "sideBar") ?  sidebarMappings[wType] : _mgMS.actTemp[wType];

  for (mapping in acm) {
    var mName = acm[mapping].name;

    if (mgWinMode == "sideBar") {
      if (mapping.indexOf(":") == 0) {
          var isWheel = isNaN(mapping.charAt(2));

          if ((isWheel && !mgPrefs.enableWheelRockers) ||
              (!isWheel && !mgPrefs.enableRockers))
            continue;
        }
        else if (!mgPrefs.enableStrokes)
          continue;
    }

    var tc = mgE("trcat" + acm[mapping].cat);
    draw(mgCanvas, mapping);

    mgCommon.addTreeRow(tc, new Array(decodeURIComponent(mName),
                            mgCommon.mappingLocalizer.localize(mapping)), "act" + mapping,
                            (mgPrefs["misc." + mgWinMode + ".canvas"]) ? mgCanvas.toDataURL() : null);

    mgCanvas.clearRect(0, 0, mgCanvas.width, mgCanvas.height);
  }

  for (var x = 0; x < mgCatLen; x++) {
    var tCat = mgE("trcat" + x);
    tCat.parentNode.setAttribute("hidden", (tCat.childNodes.length) ? false : true);
  }

  setTimeout("mapTree.removeAttribute('mozgestHide')", 0);
  restoreScroll();
}

function clearTree() {
  for (var x=0; x < mgCatLen; x++) {
    var tc = mgE("trcat" + x);

    while (tc.hasChildNodes())
      tc.removeChild(tc.firstChild);
  }
}

function sortTree(w) {
  var sortBy = new Array();

  var acm = (mgWinMode == "sideBar") ?  sidebarMappings : _mgMS.actTemp;

  for (mapping in acm[w]) {
    var mName = acm[w][mapping].name;
    var mCount = acm[w][mapping].count;
    sortBy[sortBy.length] = [mName, mapping, mCount];
  }

  if (mgPrefs["misc." + mgWinMode + ".sortByUsage"])
    sortBy.sort(function(a, b) {return ((a[2])>(b[2]) ? 1 : -1)} );
  else
    sortBy.sort(function(a, b) {return ((a[0].toLowerCase())>(b[0].toLowerCase()) ? 1 : -1)} );

  var temp = acm[w];
  acm[w] = new Array()

  for (var x = 0; x < sortBy.length; x++) {
    var mapping = sortBy[x][1];
    acm[w][mapping] = temp[mapping];
  }
}

function handleArguments(editMode, eCode) {
  if (mgWinMode == "sideBar")
    return;

  if (editMode == "directEdit") {
    var item = mgE("act" + eCode);
    var cat = _mgMS.actTemp[wType][eCode].cat;

    mgE("trItemcat" + cat).setAttribute("open", true);
    mapTree.view.selection.select(mapTree.view.getIndexOfItem(item));
    mapTree.boxObject.ensureRowIsVisible(mapTree.view.getIndexOfItem(item));

    mapTree.focus();
    editMapping("Edit");
  }
  else if (editMode == "Import")
    editMapping("Import");
  else
    editMapping("New");
}

function editMapping(mode) {
  if (mgWinMode == "sideBar") {
    mgCommon.openDialog('chrome://mozgest/content/pref/mappings.xul',
                        ['directEdit', wType, mgSelectedMapping]);
    return;
  }

  if (mode == "Import") {
    wType =_mgMS.importWinType;
    mgSelectedMapping = _mgMS.importCode;
  }

  mgCommon.openDialog("chrome://mozgest/content/pref/edit-mapping.xul", [mode, wType, mgSelectedMapping]);
}

function removeMapping() {
  exportButton.disabled = true;
  var delArray = new Array();

  for (var x = 0; x < mapTree.view.rowCount; x++) {
    if (mapTree.view.selection.isSelected(x)) {
      var tc = mapTree.view.getItemAtIndex(x);

      if (tc.id.indexOf("trItemcat") != 0)
        delArray[tc.id] = true;
    }
  }

  mapTree.view.selection.clearSelection();
  // rebuild _mgMS.actTemp
  var temp = _mgMS.actTemp[wType];
  _mgMS.actTemp[wType] = new Array();

  for (mapping1 in temp) {
    if ("act"+mapping1 in delArray)
      continue;

    _mgMS.actTemp[wType][mapping1] = temp[mapping1];
  }

  showMappingsFor(wType);
}

function publishMapping() {
  var mapping = _mgMS.actTemp[wType][mgSelectedMapping];
  var func = mapping.func;
  var name = mapping.name;

  var link = "mozgest://addmapping/" + wType + "/" + mgSelectedMapping + "/";
  link += "custom/" + name + "/" + func;
  link += "/cat" + mapping.cat + "/";

  mgE("mgLinkTargetBox").value = link;
  mgE("mgLinkTargetBox").mgHTMLvalue = "<a href=\"" + link + "\">" + decodeURIComponent(name)
                                       + " (" + mgSelectedMapping + ")" + "</a>";

  var bx = mgE("publishButton").boxObject;
  mgE('mozgestPublishPanel').openPopupAtScreen(bx.screenX, bx.screenY, false);
}

function restoreDefault() {
  var label = mgE("restoreButton").label;

  if (mgCommon.prompt.confirm(window, label, mgCommon.getString('restoreWarning')))
    mgCommon.backup.restoreDefault(label);
}

function updateButtons(tr, btns) {
  mgSelectedMapping = false;

  btns.setAttribute("disabled", true);
  var sel = tr.view.selection;

  if (sel.count == 0)
    return;

  var index = sel.currentIndex;

  if (sel.isSelected(index) && tr.view.isContainer(index))
    sel.clearRange(index, index);

  if (sel.count == 1 && !tr.view.isContainer(index)) {
    btns.setAttribute("disabled", false);

    for (var x = 0; x < mapTree.view.rowCount; x++) {
      if (mapTree.view.selection.isSelected(x))
        sel.select(index);
    }

    var mapping = tr.view.getItemAtIndex(index).id.substring(3);
    var acm = (mgWinMode == "sideBar") ?  sidebarMappings : _mgMS.actTemp;

    if (mapping in acm[wType]) {
      mgSelectedMapping = mapping;

      if (acm[wType][mapping].type != 1)
        mgE("publishButton").setAttribute("disabled", true);
    }
  }

  mgE("removeButton").disabled = (sel.count > 0) ? false : true;
}

function mgPrefHandler(data) {
  initMappingsWindow(true, wType);
}

var mgMappingsObserver = {
  obs : Components.classes["@mozilla.org/observer-service;1"]
        .getService(Components.interfaces.nsIObserverService),

  observe: function(subject, topic, data) {
    if (topic == "nsPref:changed") {
      if (data == "enableStrokes" || data == "enableRockers" ||
          data == "enableWheelRockers" || data == "misc." + mgWinMode + ".sortByUsage" ||
          data == "misc." + mgWinMode + ".canvas" || data.indexOf("window.") == 0)
        setTimeout(mgPrefHandler, 0, data);

      return;
    }

    if (data == "tempMappingsUpdated" && mgWinMode == "mappingsWin") {
      exportButton.disabled = true;
      showMappingsFor(wType);
    }

    if (data == "mappingsUpdated") {
      exportButton.disabled = false;
      setActTemp();
      showMappingsFor(wType);
    }
  },

  register : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .addObserver("", this, false);

    this.obs.addObserver(this, "mozgestControl", false);
  },

  unregister : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .removeObserver("", this);

    this.obs.removeObserver(this, "mozgestControl", false);

    try {
      if (mgWinMode == "mappingsWin")
        window.opener.focus();
    }
    catch (e) {}
  }
}

function validElt(e) {
  var su = mgE("sortByUsage");
  su.removeAttribute("tooltiptext");
  su.setAttribute("checked", mgPrefs["misc." + mgWinMode + ".sortByUsage"]);
  mgE("contextCanvas").setAttribute("checked", mgPrefs["misc." + mgWinMode + ".canvas"]);
  mgE("mgEditThisGesture").hidden = true;

  if (e.originalTarget.id != "mapTreeChildren" || !mgSelectedMapping)
    return false;

  su.setAttribute("tooltiptext", su.getAttribute("countLabel") +
                                 " " + _mgMS.activeMappings[wType][mgSelectedMapping].count);

  mgE("mgEditThisGesture").hidden = (mgWinMode == "sideBar") ? false : true;

  return true;
}

function checkCommand(e) {
  if (mgCommon.checkWindowOpen("chrome://mozgest/content/pref/edit-mapping.xul", true)) {
    e.preventDefault();
    e.stopPropagation();
  }
}

function onAcceptMappings() {
  _mgMS.updateMappingsFromTemp();
  return true;
}

function onCancel() {
  _mgMS.cleanUp();
  return true;
}

addEventListener("command", checkCommand, true);