/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "frmfilemanager.h"
#include "filelistview.h"
#include "appconfig.h"
#include "fmpixmap.h"

#include <stdlib.h>

#include <qlistview.h>
#include <qpushbutton.h>
#include <phoneman.h>
#include <qptrlist.h>
#include <qlistview.h>
#include <qheader.h>
#include <qfiledialog.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qstringlist.h>
#include <qpopupmenu.h>
#include <qpixmap.h>

frmFileManager::frmFileManager(QWidget *parent, PhoneMan * ph, appConfig * cfg, const char *name)
		: frmFileManager_base(parent, name)
{
	fileCount=0;
	fileList=0;
	phone=ph;
	myCfg=cfg;
	lastFolder="";
	reqID=-1;
	
	pxMap=new fmPixmap(this,"fmPixmap");
	lstFiles->header()->resizeSection(0,180);

	for (int i=2; i<=5; i++)
		lstFiles->setColumnAlignment(i, Qt::AlignRight);

	for (int i=1; i<=5; i++)
		lstFiles->header()->resizeSection(i,70);

	lstFiles->header()->setStretchEnabled(0,TRUE);
	lstFiles->header()->adjustHeaderSize();
	connect(phone, SIGNAL(nfoFileList(int, P2kFile*, int )), this, SLOT(nfoFileList(int, P2kFile*, int )));
	connect(phone, SIGNAL(nfoComplete(int, const QString& )), this, SLOT(onComplete(int )));
}


frmFileManager::~frmFileManager()
{}

void frmFileManager::onComplete(int act)
{
	
	if (myCfg->cfgAutoUpdateFileList)
	{
		if ((act==TASK_UPLOADFILES) || (act==TASK_DELETEFILES))
			onUpdateList();
	}
}

void frmFileManager::onUpdateList()
{
	lstDir->clear();
	lstFiles->clear();
	if (fileCount>0) free(fileList);
	fileCount=-1;

	QListViewItem * tmp = new QListViewItem(lstDir, "Phone");
	tmp->setPixmap(0,pxMap->folderPixmap("Phone"));
	reqID=phone->getFileList();
}

void frmFileManager::nfoFileList(int req, P2kFile * fl, int fc)
{
	if (req!=reqID && req!=-1) return;
	if (fileCount<0)
	{
        	fileCount=fc;
        	fileList=(P2kFile *)malloc(fileCount*sizeof(P2kFile));
		memcpy(fileList, fl, fileCount*sizeof(P2kFile));	    
	}
	else
	{
		P2kFile * fl1;
		int cnt1;
		cnt1=fileCount+fc;
		fl1=(P2kFile *)malloc(cnt1*sizeof(P2kFile));
		memcpy(fl1,fileList,fileCount*sizeof(P2kFile));
		memcpy(fl1+fileCount,fl,fc*sizeof(P2kFile));
		free(fileList);
		fileList=fl1;
		fileCount=cnt1;
		for (int i=0; i<fileCount; i++)
		    fileList[i].id=i+1;
	}

	qDebug("Filelist received: %d", fileCount);
	rebuildTree();
}

QListViewItem* frmFileManager::addDir(QListViewItem * parent, const QString& dir)
{
	QListViewItem * newItm;
	int c = dir.contains('/');
	QString s;
	if (c>1)
	{
		QString s2=dir.section('/',0,c-1, QString::SectionIncludeLeadingSep);
		parent=addDir(parent, s2);
		s=dir.section('/',c,c);
	}
	else
		s=dir;

	QListViewItem * tmp = parent->firstChild();
	while (tmp)
	{
		if (tmp->text(0)==s)
			return(tmp);
		tmp=tmp->nextSibling();
	}
	QString n2="";
	if (c>1) n2=parent->text(1)+"/";
	
	newItm=new QListViewItem(parent,s,n2+s);
	newItm->setPixmap(0, pxMap->folderPixmap(n2+s));
	if (lastFolder==n2+s) selItem=newItm;
	if (myCfg->cfgAutoExpandDirTree) newItm->setOpen(TRUE);
	return(newItm);
}

void frmFileManager::rebuildTree()
{
	lstDir->clear();
	lstFiles->clear();
	int i;
	QString s;
	QString s1;

	QListViewItem * tmp = new QListViewItem(lstDir, "Phone");
	tmp->setPixmap(0,pxMap->folderPixmap("Phone"));
	selItem=0;

	for (i=0; i< fileCount; i++)
	{
		s=fileList[i].name;
		s1=s.section('/',0,s.contains('/')-1, QString::SectionIncludeLeadingSep);
		addDir(tmp, s1);

	}
	tmp->setOpen(TRUE);
	if ((myCfg->cfgGoLastFolder) &&  (selItem))
	{
		lstDir->setSelected(selItem, TRUE);
		selItem=selItem->parent();
		while (selItem)
		{
			lstDir->setOpen(selItem, TRUE);
			selItem=selItem->parent();
		}
	}
}

void frmFileManager::onFolderChanged(QListViewItem * sel)
{
	lstFiles->clear();
	if (sel==lstDir->firstChild()) return;
	qDebug("SELCHANGE: %s",sel->text(1).latin1());
	lastFolder=sel->text(1);
	
	txtPath->setText(sel->text(1)+"/");
	
	int i;
	QString dir=sel->text(1);
	QString s;
	int cnt=dir.contains('/')+1;
	for (i=0; i< fileCount; i++)
	{
		s=fileList[i].name;
		if (s.startsWith(dir) && (s.contains('/') == cnt))
			addFile(&fileList[i]);
	}
}

void frmFileManager::addFile(P2kFile * fl)
{
	QListViewItem * itm =new FileListViewItem(lstFiles, QString::fromLocal8Bit(fl->name), 
		fl->id, fl->size, fl->owner, fl->attr);
	itm->setPixmap(0,pxMap->filePixmap(QString(fl->name)));
}

void frmFileManager::onDownload()
{
	QListViewItem * test;
	P2kFile * buf;
	int cnt=0;
	QString dir;

	test=lstFiles->firstChild();
	while (test)
	{
		if (test->isSelected() && (!test->text(6).isNull())) cnt++;
		test=test->nextSibling();
	}

	if (cnt==0) return;

	buf=(P2kFile *) malloc(cnt*sizeof(P2kFile));

	cnt=0;
	test=lstFiles->firstChild();
	while (test)
	{
		if (test->isSelected() && (!test->text(6).isNull()))
		{
			qDebug("File to download: %s",(const char *)test->text(6).local8Bit());
			buf[cnt++]=fileList[test->text(5).toInt()-1];
		}
		test=test->nextSibling();
	}
	if (cnt==1)
		dir=QFileDialog::getSaveFileName(QString::fromLocal8Bit(buf[0].name).section('/',-1,-1));
	else
		dir=QFileDialog::getExistingDirectory();
	if (dir.isNull())
	{
		free(buf);
		return;
	}
	phone->downloadFiles(buf, cnt, dir.local8Bit());
	free(buf);
}

void frmFileManager::onUpload()
{
	QStringList files=QFileDialog::getOpenFileNames();
	QStringList list = files;
	QStringList::Iterator it = list.begin();

	P2kFile * buf;

	unsigned char newattr;
	
	newattr=0;
	if (chkSystem->isChecked()) newattr++;
	newattr<<=1;
	if (chkHidden->isChecked()) newattr++;
	newattr<<=1;
	if (chkReadOnly->isChecked()) newattr++;
		
	
	if (list.count()==0) return;
// 	if (lstDir->selectedItem()==NULL) return;
	if (txtPath->text().isNull()) return;
	QString dir=txtPath->text();
	if(!dir.endsWith("/")) dir=dir+"/";
	
	int ps;
	buf=(P2kFile *) malloc (sizeof(P2kFile)*list.count());
	ps=0;

	QString s;
	while( it != list.end() )
	{
		s=*it;
		qDebug("File to upload: %s",(const char*)s.local8Bit());

		strcpy(buf[ps].name, s.section('/',-1,-1).local8Bit());
		buf[ps].attr=newattr;
		++ps;
		++it;
	}
	QString s1=s.section('/',0,s.contains('/')-1, QString::SectionIncludeTrailingSep);
	phone->uploadFiles(buf, list.count(), s1.local8Bit(), dir.latin1());
	free(buf);

}

void frmFileManager::onDelete()
{
	QListViewItem * test;
	P2kFile * buf;
	
	int cnt=0;
	test=lstFiles->firstChild();
	while (test)
	{
		if (test->isSelected() && (!test->text(6).isNull())) cnt++;
		test=test->nextSibling();
	}
	if (cnt==0) return;
	buf=(P2kFile *) malloc(cnt*sizeof(P2kFile));

	cnt=0;
	test=lstFiles->firstChild();
	while (test)
	{
		if (test->isSelected() && (!test->text(6).isNull()))
		{
			qDebug("File to delete: %s",test->text(6).latin1());
			buf[cnt++]=fileList[test->text(5).toInt()-1];
		}
		test=test->nextSibling();
	}
	phone->deleteFiles(buf, cnt);
	free(buf);
}

void frmFileManager::onChangeAttr()
{
	QListViewItem * test;
	P2kFile * buf;
	unsigned char newattr;
	
	newattr=0;
	/*if (chkSystem->isChecked()) newattr++;
	newattr<<=1;
	if (chkHidden->isChecked()) newattr++;
	newattr<<=1;
	if (chkReadOnly->isChecked()) newattr++;
	*/
	
	if (chkReadOnly->isChecked()) newattr |= 0x01;
	if (chkHidden->isChecked()) newattr |= 0x02;
	if (chkSystem->isChecked()) newattr |= 0x04;
	if (chkVolume->isChecked()) newattr |= 0x08;
	if (chkDirectory->isChecked()) newattr |= 0x10;
	if (chkArchive->isChecked()) newattr |= 0x20;
	if (chkNoDistribute->isChecked()) newattr |= 0x40;
	
	
	int cnt=0;
	test=lstFiles->firstChild();
	while (test)
	{
		if (test->isSelected() && (!test->text(6).isNull())) cnt++;
		test=test->nextSibling();
	}
	if (cnt==0) return;
	buf=(P2kFile *) malloc(cnt*sizeof(P2kFile));

	cnt=0;
	test=lstFiles->firstChild();
	while (test)
	{
		if (test->isSelected() && (!test->text(6).isNull()))
		{
			qDebug("File to Change Attr: %s",test->text(6).latin1());
			buf[cnt]=fileList[test->text(5).toInt()-1];
			buf[cnt].attr=newattr;
			++cnt;
		}
		test=test->nextSibling();
	}
	phone->changeAttr(buf, cnt);
	free(buf);
}

void frmFileManager::onFileSelChanged()
{
	QListViewItem * test=lstFiles->firstChild();
	
	while (test)
		if (test->isSelected()) break; else test=test->nextSibling();
	if (!test) return;
	
	unsigned short tst=test->text(4).toShort();
	chkReadOnly->setChecked(tst & 0x01);
	chkHidden->setChecked(tst & 0x02);
	chkSystem->setChecked(tst & 0x04);
	chkVolume->setChecked(tst & 0x08);
	chkDirectory->setChecked(tst & 0x10);
	chkArchive->setChecked(tst & 0x20);
	chkNoDistribute->setChecked(tst &  0x40);
}

void frmFileManager::contextMenuEvent(QContextMenuEvent * event)
{
	// Very ugly
	if (!QRect(lstFiles->mapToGlobal(lstFiles->viewport()->frameGeometry().topLeft()),
			lstFiles->mapToGlobal(lstFiles->viewport()->frameGeometry().bottomRight()))
			.contains(event->globalPos()))
		return;
	QPopupMenu cm(this);
	cm.insertItem(tr("Download"), this, SLOT(onDownload()));
	cm.insertItem(tr("Delete"), this, SLOT(onDelete()));
	cm.insertSeparator();
	cm.insertItem(tr("Upload"), this, SLOT(onUpload()));
	cm.insertSeparator();
	cm.insertItem(tr("Update list"), this, SLOT(onUpdateList()));
	cm.exec(event->globalPos());
}

void frmFileManager::onSearch()
{
	lstDir->clear();
	lstFiles->clear();
	if (fileCount>0) free(fileList);
	fileCount=-1;

	QListViewItem * tmp = new QListViewItem(lstDir, "Phone");
	tmp->setPixmap(0,pxMap->folderPixmap("Phone"));	
	reqID=phone->search(txtSearchRequest->text().latin1());
}

void frmFileManager::onCreateDirectory()
{
	phone->createDirectory(txtPath->text().latin1());
}

void frmFileManager::onRemoveDirectory()
{
	phone->removeDirectory(txtPath->text().latin1());
}
