/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CUSTMSG_H
#define CUSTMSG_H

// Custom Events

#define MSG_P2KLOG 10000
#define MSG_STATUS_CHANGED 10001
#define MSG_MODE_CHANGED 10002
#define MSG_PARAM_INFO 10003
#define MSG_FILELIST 10004

#define MSGSTYLE_NONE 0
#define MSGSTYLE_DEBUG 1
#define MSGSTYLE_ERROR 2
#define MSGSTYLE_INFO 3


// AT Mode will be implemented in future
#define CONNECT_NONE 0
#define CONNECT_AT 1
#define CONNECT_P2K 2

#define PARAM_DRIVENAME 1
#define PARAM_PHONEMODEL 2
#define PARAM_FREESPACE 3
#define PARAM_FILECOUNT 4
#define PARAM_PROGRESS 5
#define PARAM_SEEMREADY 6
#define PARAM_COMPLETE 7

#include <stdlib.h>
#include <string.h>
#include <qevent.h>

// Send message to log
class msg_P2kLog : public QCustomEvent
{
public:
	msg_P2kLog(int style, const QString &s)
			: QCustomEvent( MSG_P2KLOG ), msg (s) { st=style; }
	int style() const { return st; }
	QString message() const { return msg; };
private:
	int st;
	QString msg;
};

class msg_StatusChanged : public QCustomEvent
{
public:
	msg_StatusChanged(int status)
			: QCustomEvent( MSG_STATUS_CHANGED ) { st=status; }
	int status() const { return st; }
private:
	int st;
};

class msg_ModeChanged : public QCustomEvent
{
public:
	msg_ModeChanged(int mode)
			: QCustomEvent( MSG_MODE_CHANGED ) { st=mode; }
	int mode() const { return st; }
private:
	int st;
};

class msg_ParamInfo : public QCustomEvent
{
public:
	msg_ParamInfo(int param, const QString &s)
			: QCustomEvent( MSG_PARAM_INFO ), st(s) { p=param; }
	int param() const { return p; }
	QString info() const { return st; }
private:
	int p;
	QString st;
};

typedef struct P2kFile
{
	int id;
	char name[256];
	unsigned long size;
	unsigned char owner;
	unsigned char attr;
}
P2kFile;

class msg_FileList: public QCustomEvent
{
public:
	msg_FileList(int count): QCustomEvent(MSG_FILELIST)
	{
		cnt=count;
		arr=(P2kFile*) malloc (count*sizeof(P2kFile)); idx=0;
	}

	~msg_FileList() { free( arr); }

	void addItem(const int id, const char * fn, const long sz,
	             const unsigned char own, const unsigned char at )
	{
		arr[idx].id=id; strcpy(arr[idx].name, fn);
		arr[idx].size=sz; arr[idx].owner=own; arr[idx].attr=at;
		idx++;
	}

	P2kFile * getArr() const { return arr; }
	int getCount() const { return cnt; }
	
private:
	int cnt;
	int idx;
	P2kFile * arr;
};

P2kFile * fileByName(char * name, P2kFile * lst, int cnt);

void postLogMessage(QObject * target, int style, const QString &msg);

#endif
