.\" Copyright (c)  2000, 2001, Amnon BARAK (amnon@cs.huji.ac.il)
.\" All rights reserved.
.\"
.\"	MOSIX $Id: mon.man,v 1.9 2001/12/24 21:55:19 amnons Exp $
.\"
.\" THIS MANUAL IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
.\" WHATSOEVER. NO LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING
.\" FROM THE USE OF THIS MANUAL WILL BE ACCEPTED.
.\"
.Dd August 3, 2001
.Dt MON 1
.ds vT MOSIX Reference Manual
.Os MOSIX
.Sh NAME
.Nm \&mon
.Nd MOSIX load monitor
.Sh SYNOPSIS
.Nm \&mon
.Op Fl v | w
.Op Fl t
.Op Fl d
.Op Fl s
.Op Fl m
.Op Fl r
.Op Fl u
.Op Fl l
.Sh DESCRIPTION
.Nm \&Mon
displays a bar-chart, normally showing the loads on the various MOSIX
nodes.  Alternately, it can display some other information, such as
the processor speeds or the amount of available vs. total memory.

The following options are available:
.Bl -tag -width abc indent
.It Fl v
Select vertical numbering.  This allows the load of more nodes to be
displayed at any one time.
.It Fl w
Select horizontal numbering.  Although this allows the load of less nodes
to be displayed at any one time, it visually looks better.
.It Fl t
Display the count of operational nodes.
.It Fl d
Display also dead (not responding) nodes.
.It Fl s
Initially display processor-speeds.
.It Fl m
Initially display logically-used vs. total memory (see below).
.It Fl r
Initially display raw-used vs. total memory (see below).
.It Fl u
Initially display utilizability (see below).
.It Fl l
Initially display the load (default).
.El
.Pp
While in
.Pa mon ,
the following keys may be used:
.Bl -tag -width enter indent
.It Pa h
bring up a help screen.
.It Pa Enter
redraw the screen.
.It Pa v
select vertical numbering.
.It Pa w
select horizontal numbering.
.It Pa a
select automatic numbering.  Vertical numbering will be selected if it would
make the difference between being able to simultaneously view the loads of all
nodes or not.  Otherwise, horizontal numbering is selected.
.It Pa s
display processor-speeds instead of loads.
.br
10000 units represent one Pentium-2 at 400 MHz.
.br
For SMP nodes, this option also displays the number of nodes.
.It Pa m
display logically-used vs. total memory: the used memory is displayed as a
solid bar while the total memory is extended with '+' signs.  The memory is
shown in megabytes.
.It Pa r
display raw-used (non-free) memory vs. total memory: the used memory is
displayed as a solid bar while the total memory is extended with '+' signs.
The memory is shown in megabytes.
.It Pa u
display processor utilizability percentage.  This means how much of the time
either the node is serving some process, or there are no processes
on that node waiting for swapped-pages.  Under normal operating
conditions, utilizability should be 100%, dropping only when the memory
is under pressure.
.It Pa l
display loads again.
.It Pa d
display also dead (not-responding) nodes.
.It Pa D
stop displaying dead nodes.
.It Pa t
toggle displaying the count of operational nodes.
.It Pa y
display the
.Pa yardstick :
this is the speed of the most typical processor in the MOSIX cluster,
10000 units representing one Pentium-2 at 400 MHz.  Under normal
conditions, the load caused by one 'number-crunching' process running on a
single processor whose speed is the
.Pa yardstick
will be displayed as 1.  A similar process running on a faster
processor and/or an SMP, will show a load of less than 1, and on a
slower processor, more than 1.
.It Pa Right-Arrow
move one node to the right (when not all nodes fit on the screen).
.It Pa Left-Arrow
move one node to the left (when not all nodes fit on the screen).
.It Pa n
move one screen to the right (when not all nodes fit on one screen).
.It Pa p
move one screen to the left (when not all nodes fit on one screen).
.It Pa q
Quit
.Pa mon .
.El
.Sh SEE ALSO
.Xr mosix 7 ,
.Xr setpe 1 .
.Sh HISTORY
.Pa mon
is a MOSIX utility.
