# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: entrychk.tcl,v 2.2 2000/12/31 23:14:19 jfontain Exp $}


proc setupEntryValidation {path scripts {mode key}} {
    if {[llength $scripts]==0} return
    $path configure -validate $mode -invalidcommand bell
    foreach script $scripts {
        if {[info exists command]} {
            append command &&
        } else {
            set command "expr \{"
        }
        append command "\[$script\]"
    }
    append command \}
    $path configure -validatecommand $command
}

proc checkUnsignedInteger {string} {
    return [regexp {^[\d]*$} $string]
}

proc checkMaximumLength {length string} {
    return [expr {[string length $string]<=$length}]
}
