/* 
 *   Creation Date: <1999/03/29 05:22:45 samuel>
 *   Time-stamp: <2003/05/23 15:13:06 samuel>
 *   
 *	<long_lseek.c>
 *	
 *	64-bit lseek (for block devices)
 *   
 *   Copyright (C) 1999, 2000, 2001, 2003 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include <sys/ioctl.h>
#include <sys/file.h>
#include "llseek.h"

#ifdef __linux__
#define BLKGETSIZE _IO(0x12,96)		/* from <linux/fs.h> */
#endif

ulong
get_file_size_in_blks( int fd )
{
	struct stat st;
	ulong num_blocks;
	
	if( fstat(fd, &st) < 0 ) {
		perrorm("fstat");
		return 0;
	}
	num_blocks = st.st_size >> 9;
	if( S_ISBLK(st.st_mode) ) {
#ifdef __linux__
		/* note: certain devices (e.g. /dev/sr0 does not implement BLKGETSIZE) */
		if( ioctl( fd, BLKGETSIZE, &num_blocks ) < 0 )
			return 0;
#else
		/* XXX: Fixme */
		return 0;
#endif
	}
	return num_blocks;
}

