/* 
 *   Creation Date: <2002/10/03 01:13:15 samuel>
 *   Time-stamp: <2002/10/29 19:30:19 samuel>
 *   
 *	<of.h>
 *	
 *	Misc
 *   
 *   Copyright (C) 2002 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_OF
#define _H_OF

#include "config.h"
#include "types.h"
#include "string.h"
#include "ofmem.h"

/* misc.c */
extern void		qsort( void *base, size_t nmemb, size_t size, int (*compar)(const void*, const void*));
#define bzero(s,n)	memset( s, 0, n )
extern long int		strtol( const char *nptr, char **endptr, int base );
#define atol(nptr)	strtol(nptr, NULL, 10 )
extern void		fatal_error( const char *str );
extern void		exit( int status );

/* video.c */
extern void		init_video( void );
extern int		video_get_res( int *w, int *h );
extern void		draw_pixel( int x, int y, int colind );
extern void		fill_rect( int col, int x, int y, int w, int h );
extern void		set_color( int index, ulong color );
extern void		refresh_palette( void );

/* console.c */
extern int		console_draw_str( const char *str );
extern void		console_close( void );

/* start.S */
extern void 		flush_icache_range( char *start, char *stop );
extern char		of_rtas_start[], of_rtas_end[];

/* other stuff */
extern int		printm( const char *fmt, ... ) __attribute__ ((format (printf, 1, 2)));
extern int		sprintf( char *d, const char *fmt, ... );

extern void 		of_startup( void );
extern void 		of_cleanup( void );

extern int		of_client_interface( int *params );


#endif   /* _H_OF */
