/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.14 2001/12/30 22:54:25 ostborn Exp $
*/
#ifndef _PROCESSOR_PLUGIN_CONFIG_H_
#define _PROCESSOR_PLUGIN_CONFIG_H_

#include <stdio.h>
#include <pcre.h>

#include "mlist.h"

typedef struct {
	char *key;
	void *value;
	long long tstmp;
} m_cache_entry;

typedef struct {
	m_cache_entry **entry;
	long long last_tstmp;
} m_cache;

typedef struct {
	mlist	*page_type;
	
	mlist	*ignore_host;
	mlist	*ignore_url;
	mlist	*ignore_ua;
	mlist	*ignore_hostmask;
	
	mlist	*hide_url;
	mlist	*hide_referrer;
	mlist	*hide_host;
	mlist	*hide_brokenlinks;
	mlist	*hide_robots;
	mlist   *hide_extension;
	
	mlist	*group_referrer;
	mlist	*group_os;
	mlist	*group_ua;
	mlist	*group_hosts;
	mlist	*group_brokenlinks;
	mlist	*group_url;
	mlist	*group_searchstrings;
	mlist	*group_robots;
	mlist   *group_extension;
	
	mlist	*searchengines;
	mlist	*splitby;
	mlist	*split_def;
	
	m_cache *host_cache;
	int     host_cache_max;
	
	char	*search_file;
	
	int	visit_timeout;
	
	int	debug_searchengines;
	int	debug_visits;
	int	debug_resolver;
	int     debug_timing;
	
} config_processor;

int mplugins_processor_web_insert_record(mconfig *ext_conf, mlist *state_list, mlogrec *record);

#endif
