/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.13 2001/12/30 23:04:28 ostborn Exp $
*/
#ifndef _INPUT_PLUGIN_CONFIG_H_
#define _INPUT_PLUGIN_CONFIG_H_

#include <stdio.h>
#include <pcre.h>

#include "mlist.h"

#define M_CLF_MAX_FIELDS	20

typedef struct {
	mlist	*match_ua;
	mlist	*match_os;
	FILE	*inputfile;
	char	*inputfilename;
	
	char	*format;
	char	*buffer;
	int	buf_len;
	int	buf_inc;
	int	read_ahead_count;
	int	read_ahead_limit;
	mlist	*record_list;
	
	pcre		*match_clf;
	pcre_extra	*match_clf_extra;
	pcre		*match_clf_extended;
	pcre_extra	*match_clf_extended_extra;
	pcre		*match_clf_squid;
	pcre_extra	*match_clf_squid_extra;
	pcre		*match_timestamp;
	pcre_extra	*match_timestamp_extra;
	pcre		*match_url;
	pcre_extra	*match_url_extra;
	pcre		*match_referrer;
	pcre_extra	*match_referrer_extra;
	
	int	trans_fields[M_CLF_MAX_FIELDS];
} config_input;

#define M_CLF_FIELD_TIMESTAMP		1
#define M_CLF_FIELD_USERNAME		2
#define M_CLF_FIELD_SERVER_IP		3
#define M_CLF_FIELD_SERVER_PORT		4
#define M_CLF_FIELD_REQUEST		5
#define M_CLF_FIELD_STATUS		6
#define M_CLF_FIELD_AUTH_USERNAME	7
#define M_CLF_FIELD_BYTES_SEND		8
#define M_CLF_FIELD_REQ_HOST		9
#define M_CLF_FIELD_USER_AGENT		10
#define M_CLF_FIELD_REFERRER		11
#define M_CLF_FIELD_DURATION		12
#define M_CLF_FIELD_REMOTE_IP		13

typedef struct {
	char	*field;
	int	id;
	char	*match;
} clf_field_def;

static const clf_field_def def[] = 
/*
  %a	Remote IP-address		- known, but not handled (jerdfelt)
  %A	Local IP-address		- not handled
  %b	Bytes sent, excluding HTTP headers. - handled
  %B	Bytes sent, excluding HTTP headers. - not handled
  %{FOOBAR}e   				- not handled
  	The contents of the environment 
  	variable FOOBAR
  %f	Filename			- not handled
  %h	Remote host			- handled
  %H	The request protocol		- not handled
  %{FOOBAR}i				- partly handled
  	The contents of Foobar: header 
  	line(s) in the request sent to 
  	the server
  %l	Remote logname 			- known, but not handled
  	(from identd, if supplied)
  %m	The request method
  %{Foobar}n
  	The contents of note "Foobar"	- not handled
  	from another module.
  %{Foobar}o
  	The contents of Foobar: header	- not handled
  	line(s) in the reply.
  %p	The canonical Port of the 	- handled
  	server serving the request
  %P	The process ID of the child 	- not handled
  	that serviced the request.
  %q	The query string (prepended 	- not handled
  	with a ? if a query string 
  	exists otherwise an empty 
  	string)
  %r	First line of request		- handled
  %s	Status.  For requests that got  - only '%>s' is handled
  	internally redirected, this is 
  	the status of the *original* 
  	request --- %...>s for the last.
  %t	Time, in common log format time - handled
  	format (standard english format)
  %{format}t				- not handled
  	The time, in the form given by 
  	format, which should be in 
  	strftime(3) format. 
  	(potentially localised)
  %T	The time taken to serve the 	- not handled
  	request, in seconds.
  %u	Remote user (from auth; may be  - handled
  	bogus if return status (%s) 
  	is 401)
  %U	The URL path requested.		- handled
  %v	The canonical ServerName of the - handled
  	server serving the request.
  %V	The server name according to	- handled
  	the UseCanonicalName setting.
*/
	{ { "%h",		M_CLF_FIELD_REQ_HOST,	"(.+?)"},
	  { "%l",		M_CLF_FIELD_AUTH_USERNAME, "(.+?)"},
	  { "%u",		M_CLF_FIELD_USERNAME,	"(.+?)"},
	  { "%t", 		M_CLF_FIELD_TIMESTAMP,	"\\[(.+?)\\]"},
	  { "\\\"%r\\\"",	M_CLF_FIELD_REQUEST,	"\"(.+?)\""},
	  { "%>s",		M_CLF_FIELD_STATUS,	"([0-9]{1,3})"},
	  { "%b",		M_CLF_FIELD_BYTES_SEND,	"([-0-9]+)"},
	  { "\\\"%{User-Agent}i\\\"",	M_CLF_FIELD_USER_AGENT, "\"(.+?)\""},
	  { "\\\"%{Referer}i\\\"",	M_CLF_FIELD_REFERRER,	"\"(.*?)\""},
	  { "%T",		M_CLF_FIELD_DURATION,	"([-0-9]+)"},
	  { "%v",		M_CLF_FIELD_SERVER_IP,	"(.+)"},
	  { "%V",		M_CLF_FIELD_SERVER_IP,	"(.+)"},
	  { "%p",		M_CLF_FIELD_SERVER_PORT, "([-0-9]+)"},
	  { "%a",		M_CLF_FIELD_REMOTE_IP,	"(.+)"},
		  
	  { NULL, 0, NULL}
};

int mplugins_input_clf_get_next_record(mconfig *ext_conf, mlogrec *record);

#endif
