/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.4 2001/11/07 00:13:50 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

/* this code is taken from the squid plugin */

/* init the plugin */

int mplugins_input_bsdftpd_dlinit(mconfig *ext_conf) {
	config_input *conf = NULL;
	const char *errptr;
	int erroffset = 0;

/* get the neccesary space */
	conf = malloc(sizeof(config_input));
	memset(conf, 0, sizeof(config_input));

/* set some defaults */	
	conf->inputfilename = NULL;
	
	conf->inputfile = stdin;
	
	conf->buf_len = 256;
	conf->buf_inc = 128;
	conf->buffer = malloc(conf->buf_len * sizeof(char));
	
	if ((conf->match_bsdftpd_syslog_pre = 
	     pcre_compile(
			  /* date                                                          local-host   session-id
			                                                      log-facility      magicstring       */
			  "^([a-zA-Z]{3} [ 0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2})( (<.*?>))* (.+?) ftpd\\[([0-9]+)\\]: ",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_syslog_timestamp = 
	     pcre_compile(
			  /* source ip */
			  "^([a-zA-Z]{3}) ([ 0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_user_login_success = 
	     pcre_compile(
			  /*              host     user */
			  "FTP LOGIN FROM (.+?) as (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_user_login_refused = 
	     pcre_compile(
			  /*                      host     user */
			  "FTP LOGIN REFUSED FROM (.+?) as (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_user_login_failed = 
	     pcre_compile(
			  /*                      host  user */
			  "FTP LOGIN FAILED FROM (.+?), (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_anonymous_login_success = 
	     pcre_compile(
			  /*                        host   email */
			  "ANONYMOUS FTP LOGIN FROM (.+?), (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_anonymous_login_refused = 
	     pcre_compile(
			  /*                                host */
			  "ANONYMOUS FTP LOGIN REFUSED FROM (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_connection = 
	     pcre_compile(
			  /*              host     user */
			  "connection from (.+?) \\((.+?)\\)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_put = 
	     pcre_compile(
			  /*   filename 
			               filesize          */
			  "put (.+?) = ([0-9]+?) bytes$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_append = 
	     pcre_compile(
			  /*   filename 
			               filesize          */
			  "append (.+?) = ([0-9]+?) bytes$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_mkdir = 
	     pcre_compile(
			  /*     directory */
			  "mkdir (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_delete = 
	     pcre_compile(
			  /*      filename */
			  "delete (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_get = 
	     pcre_compile(
			  /*   filename 
			               filesize          */
			  "get (.+?) = ([0-9]+?) bytes$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_user = 
	     pcre_compile(
			  /*    username              timeout */
			  "User (.+?) timed out after ([0-9]+) seconds$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_rename = 
	     pcre_compile(
			  "rename (.+?) (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_bsdftpd_rmdir = 
	     pcre_compile(
			  "rmdir (.+?)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	
	
	
	

/* connect the plugin config to the master config */	
	ext_conf->plugin_conf = conf;
	
	return 0;
}

/* destructor */

int mplugins_input_bsdftpd_dlclose(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

/* clean up everything you have opened, reserved */
	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		fclose(conf->inputfile);
	}
	
	free(conf->buffer);
	
	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_input_bsdftpd_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_input *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
		{"inputfile",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->inputfilename)},
		
/* terminate the array of options */		
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_input_bsdftpd_set_defaults(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		if (!(conf->inputfile = fopen(conf->inputfilename, "r"))) {
			fprintf(stderr, "%s %s: %s\n", _("Can't open inputfile "), conf->inputfilename, strerror(errno));
			return -1;
		}
	}
	
	return 0;
}


int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_input_bsdftpd_dlinit;
	func->dlclose = mplugins_input_bsdftpd_dlclose;
	func->parse_config = mplugins_input_bsdftpd_parse_config;
	func->set_defaults = mplugins_input_bsdftpd_set_defaults;
	func->get_next_record = mplugins_input_bsdftpd_get_next_record;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;
	 
	return 0;
}
