#!/bin/sh

set -e

PACKAGE=$(dpkg-parsechangelog | sed -ne 's/Source: \(.*\)/\1/p')
BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9.]\+\)+\?.*/\1/p')
UPSTREAM_GIT="https://github.com/garlsecurity/mod_authz_securepass"
VERSION_SEP='~'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi

echo "Fetching latest upstream code into FETCH_HEAD"
git fetch $UPSTREAM_GIT

GIT_COMMIT=`git describe --always FETCH_HEAD`
GIT_DATE=`git --no-pager log -1 --pretty=format:%cd --date=short FETCH_HEAD | sed s/-//g`
TARBALL="../${PACKAGE}_${BASE_REL}${VERSION_SEP}${GIT_DATE}.git${GIT_COMMIT}.orig.tar.gz"

git archive --format=tar --prefix="${PACKAGE}"-"${BASE_REL}${VERSION_SEP}${GIT_DATE}.git${GIT_COMMIT}/" FETCH_HEAD | \
	gzip -9fn > "$TARBALL"

echo "Suchessfully created $TARBALL"
