#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_crossword.h"
#include "udm_db.h"
#include "udm_log.h"
#include "udm_charset.h"
#include "udm_spell.h"
#include "udm_xmalloc.h"
#include "udm_stopwords.h"
#include "udm_agent.h"
#include "udm_crossword.h"

#define RESORT_WORDS	256
#define WSIZE		1024


static int AddOneCrossWord(UDM_AGENT *Indexer,UDM_SERVER *Server,UDM_CROSSWORD * CrossWord,int checkstop){
	int wlen;

	/* Check MaxWordLen and MinWordLen condition */
	wlen=strlen(CrossWord->word);
	if((wlen>Indexer->Conf->max_word_len)||(wlen<Indexer->Conf->min_word_len))
		return(0);

	if(checkstop){
		/* Stopwords checking */
		if(UdmIsStopWord(Indexer->Conf,CrossWord->word)){
			return(0);
		}
	}
	CrossWord->count+=(Indexer->wordpos<<16);


	/* Realloc memory when required  */
	if(Indexer->ncrosswords>=Indexer->mcrosswords){
		if(Indexer->mcrosswords){
			Indexer->mcrosswords+=WSIZE;
			Indexer->CrossWord=(UDM_CROSSWORD *)UdmXrealloc(Indexer->CrossWord,Indexer->mcrosswords*sizeof(UDM_CROSSWORD));
		}else{
			Indexer->mcrosswords=WSIZE;
			Indexer->CrossWord=(UDM_CROSSWORD *)UdmXmalloc(Indexer->mcrosswords*sizeof(UDM_CROSSWORD));
		}
	}

	/* Add new word */
	Indexer->CrossWord[Indexer->ncrosswords].word=strdup(CrossWord->word);
	Indexer->CrossWord[Indexer->ncrosswords].url=strdup(CrossWord->url);
	Indexer->CrossWord[Indexer->ncrosswords].count=CrossWord->count;
	Indexer->ncrosswords++;
	return(0);
}

/* This function adds a normalized word form(s) into list using Ispell */
int UdmAddCrossWord(UDM_AGENT *Indexer,UDM_SERVER *Server,UDM_CROSSWORD * CrossWord,int checkstop){
	char 	** forms, ** saveforms;
	int	have_digit=0;
	int	have_alpha=0;

	Indexer->wordpos++;

	if(Server->number_factor==0||Server->alnum_factor==0){
		char *s;
		s=CrossWord->word;
		while(*s){
			if(isdigit(*s))
				have_digit=1;
			else	
				have_alpha=1;
			if(have_digit&&have_alpha)break;
			s++;
		}
		if(have_digit){
			if(have_alpha){
				if(!Server->alnum_factor)return(0);
			}else{
				if(!Server->number_factor)return(0);
			}
		}
	}
	UdmTolower(CrossWord->word,Indexer->Conf->local_charset);

	if((saveforms=forms=UdmNormalizeWord(Indexer,CrossWord->word))){
		/* Add all NORMAL forms of the word */
		while(*forms){
			/* Add only if correct words are allowed */
			if(Server->correct_factor){
				UDM_CROSSWORD cw;
				memcpy(&cw,CrossWord,sizeof(UDM_CROSSWORD));
				cw.word=*forms;
				AddOneCrossWord(Indexer,Server,&cw,checkstop);
			}
			free(*forms);
			forms++;
		}
		free(saveforms);
	}else{
		/* If NORMAL forms has not been found  */
		/*   then we will add the word itself  */
		/* Do it only when incorrect words are */
		/* allowed by configuration            */
		if(Server->incorrect_factor)
			AddOneCrossWord(Indexer,Server,CrossWord,checkstop);
	}
	return(0);
}

int UdmFreeCrossWords(UDM_AGENT* Indexer) {
	size_t i;
	for(i=0;i<Indexer->ncrosswords;i++){
		free(Indexer->CrossWord[i].word);
		free(Indexer->CrossWord[i].url);
	}
	Indexer->ncrosswords=0;
	return(0);
}
