#ifndef _UDM_HTTP_H
#define _UDM_HTTP_H

typedef struct http_hdr_s{
	int http_lo_version;
	int status;
	char *content_type;
	char *charset;
	char *location;
	int content_length;
	char *subject;
	char *from;
	char *newsgroups;
	char *date;
	char *references;
	time_t last_modified;
	size_t hdr_size;
	char *body_ptr;
	int accept_ranges;
	int content_range;
}UDM_HTTP_HDR;

extern int http_connect(UDM_ENV * Conf,UDM_CONN *connp, char *hostname, int port, int timeout);
UDM_HTTP_HDR * http_parse_header(char *buf);
void http_hdr_free(UDM_HTTP_HDR *http_hdr);

#endif
