#ifndef _UDM_CACHE_H
#define _UDM_CACHE_H

#include "udm_config.h"
#include "udm_services.h"

/* Logd protocol structures */
typedef struct {
	time_t stamp;
	int    url_id;
	int    site_id;
	int    tag;
	int    category;
	
	int    cmd;
	int    nwords;
} UDM_LOGD_CMD;

typedef struct {
	int crc;
	int weight;
#ifdef UDM_STORE_CACHE_WRDPOS
	int wrd_pos;
#endif	
} UDM_LOGD_WRD;

/* Logd file format */

typedef struct {
	time_t	stamp;
	int	url_id;
#ifdef UDM_STORE_CACHE_WRDPOS
	int	wrd_pos;
#endif
#ifdef UDM_STORE_CACHE_SITEID
	int	site_id;
#endif
#ifdef UDM_STORE_CACHE_TAG
	int	tag;
#endif
#ifdef UDM_STORE_CACHE_CATEGORY
	int	category;
#endif
	int	wrd_id;
	int	weight;
} UDM_LOGWORD;

typedef struct {
	time_t	stamp;
	int	url_id; 
} UDM_LOGDEL;



extern int UdmOpenCache(UDM_ENV * Env, char *errmsg);
extern void UdmCloseCache(UDM_ENV  * Env);
extern int UdmClearCacheTree(UDM_ENV * Env);
extern int UdmSplitCacheLog(UDM_ENV * Env,int log);
extern int UdmPreSplitCacheLog(UDM_ENV * Env);


extern int UdmStoreWordsCache(UDM_AGENT *Indexer,int url_id,int site_id,const char *category,const char * tag);
extern UDM_SEARCHWORD * UdmFindCache(UDM_AGENT * Indexer,char *q);
extern int UdmDeleteURLFromCache(UDM_AGENT *Indexer,int url_id);

#endif
