      SUBROUTINE cleo_QRYLUN( ILUN, CUSTAT, COWNER )
C.......................................................................
C.
C. QRYLUN  - Query status of unit ILUN
C.
C. Inputs    : ILUN   - Unit number whose status is sought
C. Outputs   : CUSTAT - Text describing status of ILUN
C.           : COWNER - Owner of the unit if not free
C.
C. COMMON    :
C.
C. Calls     : None
C. Called    : <USER>
C.
C. Detailed description
C.  This routine can be used to query the status of a particular unit.
C.  The value of CUSTAT is  'FREE' if ILUN is available
C.                          'ALLO' if ILUN is allocated
C.                          'LOCK' if ILUN is locked
C.                          '????' if ILUN is out of range or the table
C.                                 appears to be corrupted
C.
C.  The value of COWNER is the name of the owner of the allocation or
C.  lock as supplied to GETLUN/LOKLUN. It is blank otherwise.
C.......................................................................
C
C------------------------- Argument declarations -----------------------
C
      INTEGER ILUN
      CHARACTER*(*) CUSTAT, COWNER
C
C------------------------- EXTERNAL declarations -----------------------
C
* None
C
C------------------------- SEQUENCE declarations -----------------------
C
C
* LUNMIN - Smallest allowed LUN number
* LUNMAX - Largest  allowed LUN number
* MAXLUN - Length of the    LUN number allocation table
*
      INTEGER    LUNMIN,     LUNMAX
      PARAMETER( LUNMIN = 1, LUNMAX = 99 )
*
      INTEGER    MAXLUN
      PARAMETER( MAXLUN = LUNMAX - LUNMIN + 1 )
*
* LISUSE - Flag for LUN is in use
* LISFRE - Flag for LUN is free
* LISLOK - Flag for LUN is locked
*
      INTEGER    LISUSE,     LISFRE,     LISLOK
      PARAMETER( LISUSE = 1, LISFRE = 0, LISLOK = -1 )
*
* LUSEER - Error, LUN in use
* LRNGER - Error, LUN number out of range
* LTABER - Error, LUN allocation table corrupted
* LFULER - Error, LUN allocation table full
* LLOKER - Error, LUN is already locked
* LFLKER - Error, LUN is locked, cannot be freed
* LINIER - Error, in initialization
* LUALER - Error, found unalloacted unit connected to file
* LNONAM - Warning, Allocator name is blank
* LDIFER - Warning, Allocator and deallocator are different
*
      INTEGER    LUSEER,     LRNGER,     LTABER,     LFULER
      PARAMETER( LUSEER = 1, LRNGER = 2, LTABER = 3, LFULER = 4 )
      INTEGER    LLOKER,     LFLKER,     LINIER,     LUALER
      PARAMETER( LLOKER = 5, LFLKER = 6, LINIER = 7, LUALER = 8 )
      INTEGER    LNONAM,     LDIFER
      PARAMETER( LNONAM = 9, LDIFER =10                         )
*
* LUNTBL - The LUN allocation table
* LUNOWN - The LUN allocation owner table
*
      INTEGER         LUNTBL
      COMMON /LUNMCI/ LUNTBL(LUNMIN:LUNMAX)
      CHARACTER*8     LUNOWN
      COMMON /LUNMCC/ LUNOWN(LUNMIN:LUNMAX)
C
C------------------------- Local    declarations -----------------------
C
      INTEGER ISTAT
C
C------------------------- SAVE     declarations -----------------------
C
* None
C
C------------------------- DATA  initializations -----------------------
C
* None
C
C---------------------- Executable code starts here --------------------
C
*
      CUSTAT = '????'
      COWNER = ' '
*
      IF( ILUN.LT.LUNMIN .OR. ILUN.GT.LUNMAX ) GOTO 999
*
      ISTAT = LUNTBL(ILUN)
      IF(     ISTAT.EQ.LISFRE ) THEN
         CUSTAT = 'FREE'
      ELSEIF( ISTAT.EQ.LISUSE ) THEN
         CUSTAT = 'ALLO'
         COWNER = LUNOWN(ILUN)
      ELSEIF( ISTAT.EQ.LISLOK ) THEN
         CUSTAT = 'LOCK'
         COWNER = LUNOWN(ILUN)
      ENDIF
*
      RETURN
  999 END
