# This file demonstrates the %eval keyword.

@head {
	$tempo 120
	$time_sig 4/4
	$resolution 210 # 210 has 5 and 7 as factors so the tuplets divide equally
}

@body {
	@channel 10 "snare" {
		%repeat 8 {
			/l4r4/sd_ac      # play 4 even beats

			# This picks a number $i from 5-7 and
			# plays $i notes inside a $i:4 %tuplet
			# block.
			
			%eval {
				$i = 5 + int(rand(3));
				"\%tuplet $i:4 \{ /l4r$i/sd_ac \}"; # this string is returned
				                                    # and replaces the %eval
													# block in the input.
			}
		}
		/l4r4/sd_ac          # play 4 even beats
	}

	@channel 10 "bass drum" {
		%repeat 17 { /l4r4/bd }  # play even beats all the way through.
	}
}
