/* mg-data-cell-renderer-info.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 * Copyright (C) 2003 Vivien Malerba <malerba@gnome-db.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MG_DATA_CELL_RENDERER_INFO_H__
#define __MG_DATA_CELL_RENDERER_INFO_H__

#include <gtk/gtk.h>
#include <libmergeant/mg-defs.h>
#include <libmergeant/mg-data-entry.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MG_DATA_CELL_RENDERER_INFO_TYPE			(mg_data_cell_renderer_info_get_type ())
#define MG_DATA_CELL_RENDERER_INFO(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), MG_DATA_CELL_RENDERER_INFO_TYPE, MgDataCellRendererInfo))
#define MG_DATA_CELL_RENDERER_INFO_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), MG_DATA_CELL_RENDERER_INFO_TYPE, MgDataCellRendererInfoClass))
#define IS_MG_DATA_CELL_RENDERER_INFO(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), MG_DATA_CELL_RENDERER_INFO_TYPE))
#define IS_MG_DATA_CELL_RENDERER_INFO_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), MG_DATA_CELL_RENDERER_INFO_TYPE))
#define MG_DATA_CELL_RENDERER_INFO_GET_CLASS(obj)         (G_TYPE_INSTANCE_GET_CLASS ((obj), MG_DATA_CELL_RENDERER_INFO_TYPE, MgDataCellRendererInfoClass))

typedef struct _MgDataCellRendererInfo MgDataCellRendererInfo;
typedef struct _MgDataCellRendererInfoClass MgDataCellRendererInfoClass;
typedef struct _MgDataCellRendererInfoPriv MgDataCellRendererInfoPriv;
typedef enum   _MgDataCellRendererInfoStatus MgDataCellRendererInfoStatus;

struct _MgDataCellRendererInfo
{
	GtkCellRenderer             parent;

	MgDataCellRendererInfoPriv *priv;
};

struct _MgDataCellRendererInfoClass
{
	GtkCellRendererClass parent_class;
	
	void (* status_changed) (MgDataCellRendererInfo       *cell_renderer_info,
				 const gchar                  *path,
				 MgDataEntryAttribute          requested_action);
};

GType            mg_data_cell_renderer_info_get_type  (void);
GtkCellRenderer *mg_data_cell_renderer_info_new       (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MG_DATA_CELL_RENDERER_INFO_H__ */
