# -*- perl -*-

use strict;
use Test;

BEGIN { plan tests => 3 }

use Juman::Morpheme;
use Juman::MList;

my $mlist = Juman::MList->new();
ok( defined $mlist );

$mlist->push_mrph( Juman::Morpheme->new( "ʸ ֤ ʸ ̾ 6 ̾ 1 * 0 * 0\n") );
$mlist->push_mrph( Juman::Morpheme->new( "   ̾ 6 ̾ 2 * 0 * 0\n" ) );

ok( $mlist->mrph == 2 );
ok( join('',map($_->midasi,$mlist->mrph)) eq 'ʸ' );
