""" An example plugin. """

import os, sys
from os.path import abspath, dirname
# Plugin definition imports.
# Imports from 'acme' library which is one hierarchy up the directory
# containing this file requires its parent directory to be present in path
plugin_dir_name = dirname(dirname(abspath(__file__)))
if not plugin_dir_name in sys.path:
    sys.path.append(plugin_dir_name)
# Imports from 'misc' requires its parent directory in the path
misc_dir = os.path.join(dirname(plugin_dir_name), 'misc')
if not misc_dir in sys.path:
	sys.path.append(misc_dir)

# Enthought library imports.
from enthought.envisage.api import PluginDefinition

# Plugin definition imports.
from enthought.envisage.core.core_plugin_definition import \
     AdapterFactory, Category, Hook, Runnable, Types


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = 'enthought.envisage.examples.plugin.acme'


###############################################################################
# Extensions.
###############################################################################

runnable = Runnable(
    class_name = 'acme.example_runnable.ExampleRunnable'
)

types = Types(
    adapter_factories = [
        AdapterFactory(
            adaptee_class_name = 'foo.Foo',
            adapter_class_name = 'acme.foo_bar_adapter.FooBarAdapter',
            target_class_name  = 'bar.Bar',
        )
    ],

    categories = [
        Category(
            class_name        = 'acme.example_category.ExampleCategory',
            target_class_name = 'foo.Foo'
        )
    ],

    hooks = [
        Hook(
            callable_name      = 'acme.foo_hook.pre_foo_hook',
            target_class_name  = 'foo.Foo',
            target_method_name = 'foo',
            type               = 'pre'
        ),

        Hook(
            callable_name      = 'acme.foo_hook.post_foo_hook',
            target_class_name  = 'foo.Foo',
            target_method_name = 'foo',
            type               = 'post'
        )
    ]
)

###############################################################################
# The plugin definition.
###############################################################################

class AcmePluginDefinition(PluginDefinition):
    """ An example plugin definition. """
    
    # The plugin's globally unique identifier.
    id = ID

    # The name of the class that implements the plugin.
    class_name = 'acme.plugin_implementation.AcmePlugin'

    # General information about the plugin.
    name          = 'Example Plugin'
    version       = '1.0.0'
    provider_name = 'Enthought Inc'
    provider_url  = 'www.enthought.com'
    
    # The Id's of the plugins that this plugin requires.
    requires = ['enthought.envisage.core']

    # The extension points offered by this plugin.
    extension_points = []

    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [runnable, types]

#### EOF ######################################################################
