"""

This file defines a simple class that handles a vtkVRMLImporter.
The class handles the deletion of the actors generated by the
vtkVRMLImporter.

This code is distributed under the conditions of the BSD license.  See
LICENSE.txt for details.

Copyright (c) 2001-2002, Prabhu Ramachandran.
"""

__author__ = "Prabhu Ramachandran <prabhu_r@users.sf.net>"
__version__ = "$Revision: 1.3 $"
__date__ = "$Date: 2002/06/06 12:02:53 $"

import vtkpython, Common

debug = Common.debug

class VRMLImporter:
    
    """This is a class that handles a vtkVRMLImporter.  The class
    handles the deletion of the actors generated by the
    vtkVRMLImporter."""

    def __init__ (self, renwin, file_name):        
        """Initializes the class given a vtkRenderWindow and a
        file_name."""
        debug ("In VRMLImporter::__init__ ()")
        self.file_name = file_name
        self.renwin = renwin
        orig_actors = self._get_actors (self.renwin)
        
        self.vrml_imp = vtkpython.vtkVRMLImporter ()
        self.vrml_imp.SetFileName (file_name)
        self.vrml_imp.SetRenderWindow (self.renwin)
        try:
            self.vrml_imp.ComputeNormalsOn ()
        except AttributeError:
            pass
        self.vrml_imp.Read ()
        self.renwin.Render ()
        final_actors = self._get_actors (self.renwin)

        self.actors = []
        for act in final_actors:
            if act not in orig_actors:
                self.actors.append (act)        

    def __del__ (self):
        debug ("In VRMLImporter::__del__ ()")
        ren = self.vrml_imp.GetRenderer ()
        for act in self.actors:
            ren.RemoveActor (act)
        self.renwin.Render ()
        del self.actors
        del self.vrml_imp
        del self.renwin
    
    def _get_actors (self, rw):        
        """ Returns a list of available actors in the given
        vtkRenderWindow."""        
        debug ("In VRMLImporter::_get_actors ()")
        act = []
        renderers = rw.GetRenderers ()
        renderers.InitTraversal ()
        n_ren = renderers.GetNumberOfItems ()
        for i in range (n_ren):
            ren = renderers.GetNextItem ()
            act.extend (self._get_actor_list (ren))

        return act
    
    def _get_actor_list (self, ren):
        """ Returns a list of available actors in the given
        vtkRenderer."""        
        debug ("In VRMLImporter::_get_actor_list ()")
        act = []
        act_col = ren.GetActors ()
        act_col.InitTraversal ()
        n_act = act_col.GetNumberOfItems ()
        for i in range (n_act):
            act.append (act_col.GetNextItem ())

        return act

    def get_file_name (self):
        """ Returns the VRML file used."""
        debug ("In VRMLImporter::get_file_name ()")
        return self.file_name
