"""

This wraps the vtkWarpScalar filter.  vtkWarpScalar is a filter that
modifies point coordinates by moving points along point normals by the
scalar amount times the scale factor.  Useful for creating carpet or
x-y-z plots.

This code is distributed under the conditions of the GPL (GNU General
Public License).  Look at the file LICENSE included with the
distribution for details.

Copyright (C) 2001, Prabhu Ramachandran.
"""

__author__ = "Prabhu Ramachandran <prabhu_r@users.sf.net>"
__version__ = "$Revision: 1.2 $"
__date__ = "$Date: 2001/11/03 09:23:34 $"

import PolyDataNormals
import Common
import vtkpython

debug = Common.debug

# derived from PolyDataNormals since it implements exactly what we need.
class WarpScalar (PolyDataNormals.PolyDataNormals):

    """ This wraps the vtkWarpScalar filter.  vtkWarpScalar is a
    filter that modifies point coordinates by moving points along
    point normals by the scalar amount times the scale factor.  Useful
    for creating carpet or x-y-z plots.  """

    def initialize (self):
        debug ("In WarpScalar::initialize ()")
        self.fil = vtkpython.vtkWarpScalar ()
        self._set_input ()
        self.fil.Update ()
