#! /usr/bin/perl
#
# $Header: //sapdb/TOOLSRC/develop/sys/src/BuildPackage/WinLink.pm#2 $
# $DateTime: 2002/06/10 14:15:26 $
# $Change: 22128 $
#
# Desc:
# This Script is itended to be used inside the SAP environment only.
# It should be only used on hs0116.wdf.sap.corp for the puspose of installing
# Testpackages for the WinRunner-Tests.
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

#
# A few basics right at the beginning:
BEGIN
{
	if ($^O =~ /win32/i)
	{
		my $testdrive = "d:";
		if ((caller())[1] =~ /^(.:)/) { 
			$testdrive = $1;	
		}
		push @INC, "$testdrive\\devtool\\bin";
		push @INC, "$testdrive\\devtool\\lib";
		push @INC, "$testdrive\\devtool\\lib\\perl5";
		push @INC, "$testdrive\\devtool\\lib\\Perl";
		push @INC, "$testdrive\\SAP_DB\\TESTDB";
		push @INC, "$testdrive\\SAP_DB\\TESTDB\\lib";
		chdir("$testdrive\\SAP_DB\\TESTDB");
	}
	else
	{
		push @INC, ("/devtool/local/bin");
		push @INC, ("/devtool/local/lib");
		push @INC, ("/devtool/local/Perl");
		push @INC, ("/devtool/local/perl5");
		push @INC, ("/SAP_DB/TESTDB");
		push @INC, ("/SAP_DB/TESTDB/lib");
        push @INC, ("/devtool/TOOL/tool/bin");
        push @INC, ("/devtool/TOOL/tool/lib/perl5");
		chdir("/SAP_DB/TESTDB");
	}
}

my %ienv = %ENV;
close STDERR;
open STDERR, ">&STDOUT";
select STDOUT;

select (STDERR);
$| = 1;
select (STDOUT);
$| = 1;

$| = 1; # Nur zur Sicherheit, damit das (unntige) Buffering ausgeschaltet wird.

use Sys::Hostname;

if ($^O =~ /MSWin32/i) {
    require File::DosGlob ;
    import  File::DosGlob 'glob';
    require WinLink;
    import  WinLink;
    require Win32::TieRegistry;
    import  Win32::TieRegistry;
    require Win32::Process;
    import  Win32::Process;
   	if (!(hostname() =~ /loanw/i)) {
	    system("NET USE L: \\\\pwdfm017\\LC_POOL ");
	} else {
		system("NET USE l: \\\\production\\MaxDB\\LC_POOL\\ntamd64");
	}
}

require testdb;
import testdb;

my %options = ();

use Getopt::Long;

my @testq;

foreach my $version ('7403', '7500', '7600') {
	foreach my $status ('COR', 'DEV') {
		push(@testq, testdb->new({'version' => $version, 'status' => $status,},  {'SESSION_TYPE' => 'WRU'}));
	}
}


foreach $x (@testq) {
	$x->{'qah'}->set_sessiontype('WRU');
	$x->preClean();
	$x->installLC();
	$x->installTF();
	$x->{'qah'}->set_sessiontype('WRU');
}



sub Sema_Lock
{
    my $lockfile = shift;

    use Fcntl ':flock';
    use FileHandle;

    my $fh = new FileHandle (">$lockfile");
    if ($fh)
    {
        flock ($fh, LOCK_EX);
        print "INFO: Lock-file '$lockfile' locked by PID $$\n";
    }
    else
    {
        print STDERR "ERROR: Opening lock-file '$lockfile' failed!\n$!\n";
        return undef;
    }

    return $fh;
}

sub Sema_Unlock
{
    my $fh = shift;

    flock($fh, LOCK_UN);
    $fh->close;
    print "INFO: Lock-file unlocked by PID $$\n";
}


sub CleanExit
{
	my ($rc) = @_;

	if (defined ($options{'preclean'}))
	{
		my $y = $testq[0];
		$y->removeAll() if ($y);
	}
	
	exit($rc);
}

__END__

=head1 NAME

testdb.pl - Automated SAPDB/LiveCache-Tests in certain environments.

=head1 NOTE

This module is intended for internal use only.
Although it is free software, it won't be very usefull for the wide world

=head1 SYNOPSIS OF CREATING A NEW ENTRY

 use qadb;
 $qah =  qadb->new({'VERSION' => '7403',
    'BUILDPFX'   => '07',
    'QASTATUS'   => 'DEV',
    'CHANGELIST' => '12345'}) ;

 if ($qah->{error_code} != 0) {
    print "Error:\n$qah->{error_text}\n";
    return -1;
 }

=head1 SYNOPSIS OF LOADING A OLD ENTRY

 use qadb;
 $qah =  qadb->new({'ID' => 1234}) ;

 if ($qah->{error_code} != 0) {
    print "Error:\n$qah->{error_text}\n";
    return -1;
 }

=head1 SYNOPSIS OF LOADING AN ENTRY FOR TESTS

 use qadb;
 $qah = qadb->new_test({'PLATFORM' => 'alphaosf', 'VERSION' => 7404, 'QASTATUS' => 'DEV'});

 if ($qah->{error_code} != 0) {
    print "Error:\n$qah->{error_text}\n";
    return -1;
 }

=head1 DESCRIPTION

The C<qadb> class is a interface to the SAP-internal QA-System for SAP DB
and liveCache.

Each instance of C<qadb> represents a complete make in the sense of making
programs out of sourcecode. Aditionaly, it can carry informations about
the status of the programs made - test results for example.

A new instance of C<qadb> can be created in two ways:

=over 4

=item Creating a new entry

A couple of informations are required to create a new entry. Following
the perl standards, the constructor of the class is named C<new>. It
requires a hash-reference with the following entries:

  Name          Description                   Example value

 VERSION       4-digit Version              '7402'
 BUILDPFX      2-digit Build-prefix         '02'
 QASTATUS      The quality-status           'DEV'
 CHANGELIST    The CL-Number                '32456'

For AIX-Machines, the aditional "PLATFORM"-entry is required. This is
necssary becase the perl-interpreter does not make a difference between
AIX 4.x and AIX 5.x as we do it.

Currently, the followning values are accepted for PLATFORM:

    - sun_64
    - alphaosf
        - rs6000_51_64
    - rs6000_64
    - hp_64

Please keep in mind that a C<qadb>-instance normaly contains a variable
called C<ID> (you can access it with B<$qah-E<gt>{'ID'}>. This C<ID> identifies
a make-entry and will be needed later. So, I suggest to write this C<ID>
to the harddisk.

=item Loading a old entry

For loading a previously created entry, you need to call the contructor with
a hash-refernece, containing the ID generated by the inital creation of
the entry.

  Name          Description                   Example value

 ID            The ID taken from inital      5739
               creation

=back

=head1 METHODS

C<qadb> provides the following methods:

=over 4

=item $rv = update_columns({name1 => value1, ... , nameN => valueN});

Performs a update-statement on the main table. This should only be used
for updating IDOBJSTATUS, LCPOOLID, LC_OK and LCOK_TRANS.

It takes a hash-reference as arguement, filled with columnnames and the
corresponing values.

The "VARIABLES"-Section of this manual contains a complete description of all
fields.

Returns 0 on success.

=item $rv = write_log($log_text);

This adds a comment to the entry. The log-Text must not contain more than
1000 characters.

Returns 0 on success.

=item $rv = write_prot($prot_name, $prot  [, $info_text]);

Writes a protocoll to the WebDAV-server and creates a entry in the
appropriate table in the database.

It takes a protocolname, the protocol itself and a optional info text as
arguments.

If the info text is not provieded, the protocolname will be used for it.

Returns 0 on success.

=item $rv = unlock();

Releases the current DB-Connection, but don't forget about the Values.

This becomes necessary when the program forkes. See B<lock> for
further informations

Returns 0 on success.

=item $qah = lock();

Re-Creates the DB-Connection. This becomes necessary after performing
an B<unlock> in forking situations.

B<TAKE CARE:> this method will return a new instance. Overwrite the current one
with it. The following example will give you an idea how to do this:

   $qah->unlock();
   $pid = fork();
   $qah = $qah->lock();

   if ($pid) {
       #
       # go on here


=back

=head1 VARIABLES

C<qadb> contains the following variables. Variables corresponding with
fields in the database are marked with a X.

Please note that B<IDQASTATUS> and B<IDPLATFORM> differ from the
parameters B<QASTATUS> and B<PLATFORM> for the C<new>-constructor. The values stored in the
database are simple numeric representations of their alphanumeric
assignments. These assignments are stored in the tables B<PLATFORMS>
and B<QASTATUS>.

  Name         DB-Variable       Description

 ID                X            Identifies the complete build-process
 LCPOOLID          X            The number in the LC_POOL-directory
 VERSION           X            A four-digit version, eg. "7402"
 BUILDPFX          X            A two-digit buildprefix, eg. "05"
 IDPLATFORM        X            The numeric id of the platform
 IDQASTATUS        X            The numeric id if the QA-status
 IDOBJSTATUS       X            The numeric id of the make-status
 CHANGELIST        X            The Changelist-number
 TS                X            The timestamp of the last modification
 LCOK              X            Will be set when the tests are finished
                                successfully.
 LCOK_TRANS        X            Will be set after the LCOK-bit is
                                transfered into the appropriate structures
                in the filesystem.
 HISTCOUNT         X            Counts the number of changes in on these
                                informations. Will be updated automaticaly.
 error_code                     Conains the last error code set. After
                                successfull opterations it will be set to
                0.
 error_text                     Contains a human-readable description of
                                the last error.

=head1 ERROR HANDLING

Beneath the already introduced variables B<error_code> and B<error_text>
for error handling, a email will be sent in each case of a detected error.

The recipients of these Mails are currently hard-coded.

=head1 DBI INSTANCE

C<qadb> contains a ready-to-use DBI instance. It can be accessed by
B<$qah-E<gt>{dbh}>. Please use this with extreme care and use it
only if you can not avoid it.

The DBI documentation describes it in depth.

=head1 EXAMPLE

 use qadb;
 my $qah =  qadb->new({'VERSION' => '7403',
    'BUILDPFX'   => '07',
    'QASTATUS'   => 'DEV',
    'CHANGELIST' => '12345'}) ;

 if ($qah->{error_code} != 0) {
    print "Fehler:\n$qah->{error_text}\n";
    return -1;
 }

 if ($qah->update_columns({'LCPOOLID' => '012'}) != 0 ) {
     print "Error while update:\n$qah->{error_text}\n";
     return -1;
 }

 if ($qah->write_log("Hallo Welt, dies ist ein Test")) {
     print "Error while writing a log:\n$qah->{error_text}\n";
     return -1;
 }

 my $protocol = "";
 open (PROTOFILE, "/path/to/protocol") or die "Error reading protocol\n";

 while (<PROTOFILE>) {
     $protocol .= $_;
 }

 if ($qah->write_prot("make.log", $protocol, "This protocol contains the make-output.\n")) {
     print "Error while writing protocol make.log:\n$qah->{error_text}\n";
 }

=head1 COPYRIGHT

Copyright 2003 SAP AG

=cut

