(**************************************************************************)
(*       ___	                                                            *)
(*      ||M||                                                             *)
(*      ||A||       A project by Andrea Asperti                           *)
(*      ||T||                                                             *)
(*      ||I||       Developers:                                           *)
(*      ||T||       A.Asperti, C.Sacerdoti Coen,                          *)
(*      ||A||       E.Tassi, S.Zacchiroli                                 *)
(*      \   /                                                             *)
(*       \ /        This file is distributed under the terms of the       *)
(*        v         GNU Lesser General Public License Version 2.1         *)
(*                                                                        *)
(**************************************************************************)

include "logic/equality.ma".

inductive void : Set \def.

inductive unit : Set ≝ something: unit.

inductive Prod (A,B:Type) : Type \def
pair : A \to B \to Prod A B.

interpretation "Pair construction" 'pair x y =
 (cic:/matita/datatypes/constructors/Prod.ind#xpointer(1/1/1) _ _ x y).

interpretation "Product" 'product x y =
 (cic:/matita/datatypes/constructors/Prod.ind#xpointer(1/1) x y).

definition fst \def \lambda A,B:Type.\lambda p: Prod A B.
match p with
[(pair a b) \Rightarrow a]. 

definition snd \def \lambda A,B:Type.\lambda p: Prod A B.
match p with
[(pair a b) \Rightarrow b].

interpretation "pair pi1" 'pi1 = (fst _ _).
interpretation "pair pi2" 'pi2 = (snd _ _).
interpretation "pair pi1" 'pi1a x = (fst _ _ x).
interpretation "pair pi2" 'pi2a x = (snd _ _ x).
interpretation "pair pi1" 'pi1b x y = (fst _ _ x y).
interpretation "pair pi2" 'pi2b x y = (snd _ _ x y).

theorem eq_pair_fst_snd: \forall A,B:Type.\forall p:Prod A B.
p = 〈 \fst p, \snd p 〉.
intros.elim p.simplify.reflexivity.
qed.

inductive Sum (A,B:Type) : Type \def
  inl : A \to Sum A B
| inr : B \to Sum A B.

interpretation "Disjoint union" 'plus A B =
 (cic:/matita/datatypes/constructors/Sum.ind#xpointer(1/1) A B).

inductive option (A:Type) : Type ≝
   None : option A
 | Some : A → option A.
