/* 

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

Display* dpy;	

static void
getRootProperty(char * name, Bool delete)
{
   Atom prop;
   Atom type, realType;
   unsigned long n;
   unsigned long extra;
   int format;
   int status;
   char * value;
	
   prop = XInternAtom(dpy, name, True);
   if (prop == None) {
      fprintf(stderr, "No such property '%s'\n", name);
      return;
   }
	
   status = XGetWindowProperty(dpy, DefaultRootWindow(dpy),
			       prop, 0L, 512L, delete,
			       AnyPropertyType, &realType, &format,
			       &n, &extra, (unsigned char **) &value);
   
   if (status != Success) { // || value == 0 || *value == 0 || n == 0) {
      fprintf(stderr, "couldn't read property on root window\n");
      return;
   }
   printf("%s\n", value);
}


static void
SetRootProperty(char *value) {

   XEvent	ev;
   Window	root;
   
   
   Atom theme_prop, cmd_prop;
   
   printf("setting prop to %s\n", value);
   
   theme_prop = XInternAtom(dpy, "_MB_THEME", False);
   if (theme_prop == None) {
      fprintf(stderr, "No such property '%s'\n", "_MB_THEME");
      return;
   }

   cmd_prop = XInternAtom(dpy, "_MB_COMMAND", False);
   if (cmd_prop == None) {
      fprintf(stderr, "No such property '%s'\n", "_MB_COMMAND");
      return;
   }
   
   
   root = DefaultRootWindow(dpy);

   XChangeProperty(dpy, root, theme_prop, XA_STRING, 8,
		   PropModeReplace, value, strlen(value));
      
   
   memset(&ev, '\0', sizeof ev);
   ev.xclient.type = ClientMessage;
   ev.xclient.window = root;
   ev.xclient.message_type = cmd_prop;
   ev.xclient.format = 8;
   ev.xclient.data.l[0] = 0;

   XSendEvent(dpy, root, False, SubstructureRedirectMask, &ev);

}


static void
usage(char *progname)
{
  printf("Usage: %s <options>\n", progname);
}

int main(int argc, char* argv[])
{
  char *display_name = (char *)getenv("DISPLAY");
  char *theme_file;
  int i;
  
  dpy = XOpenDisplay(display_name);
  if (dpy == NULL) {
     printf("Cant connect to display: %s\n", display_name);
     exit(1);
  }
  
  /* pass command line */
  for (i=1; argv[i]; i++) {
    char *arg = argv[i];
    if (*arg=='-') {
      switch (arg[1]) {
	case 'd' : /* display */
	  display_name = argv[i+1];
	  i++;
	  break;
	case 't' :
	  if (argv[i+1] != NULL)
	     {
		SetRootProperty(argv[i+1]);
	     }
	  i++;
	  break;
	case 'r' :
	   getRootProperty("_MB_THEME", False);
	  i++;
	  break;

      }
    }
  }
  XSync(dpy, True);
  XCloseDisplay(dpy);
}    

