'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: pkgMkIndex.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: pkgMkIndex.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH pkg_mkIndex n 8.3 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
pkg_mkIndex \- 为包的自动装载建造一个索引
.SH "总览 SYNOPSIS"
.nf
.VS 8.3.0
\fBpkg_mkIndex ?\fI\-direct\fR?  ?\fI\-lazy\fR?  ?\fI\-load pkgPat\fR? ?\fI\-verbose\fR? \fIdir\fR ?\fIpattern pattern ...\fR?
.VE
.fi
.BE

.SH "描述 DESCRIPTION"
.PP
\fBPkg_mkIndex\fR 是标准Tcl 库中的一个实用过程。它被用于建立索引文件，在执行 \fBpackage require\fR 的时候用它来允许自动装载包。使用 \fBpkg_mkIndex\fR要依从下面这些步骤:         
.IP [1]
建立包。
每个包可以由一个或多个 Tcl   脚本文件或二进制文件组成。二进制文件必须适合使用有一个单一参数的 \fBload\fR 命令装载；例如，如果文件是 \fBtest.so\fR  它必须可能用命令 \fBload test.so  \fR命令来装载这个文件。每个脚本文件必须包含一个 \fBpackage provide\fR  命令来声明包和版本号，而每个二进制文件必须包含一个对 \fBTcl_PkgProvide\fR的调用。            
.IP [2]
通过调用 \fBpkg_mkIndex \fR建立索引。
用 \fIdir\fR              
参数给出一个目录的名字并且每个\fIpattern\fR  参数都是在 \fIdir\fR\fI \fR中选择脚本或二进制文件的一个通配符式样的模式。
.VS 8.0.3
缺省的模式是 \fB*.tcl\fR 和 \fB*.[info sharedlibextension]\fR。
.VE
.br
\fBPkg_mkIndex\fR 将在 \fIdir\fR   中建立一个文件 \fBpkgIndex.tcl\fR，其中有关于用 \fIpattern\fR  参数给出的所有文件的包信息。它通过把每个文件装载到一个从解释器中并查看出现了那些包和新命令来完成这项工作(这就是上面描述的在这些文件中必须有 \fBpackage provide\fR  命令或 \fBTcl_PkgProvide\fR 调用的原因)。如果你有一个分开成多个脚本和二进制文件的包，或有文件间的依赖，你可能必须使用 \fB-load\fR 选项或调整 \fBpkg_mkIndex\fR 处理这些文件的次序。参见下面的 COMPLEX CASES 复杂情况。        

.IP [3]
把包安装为由 \fBtcl_pkgPath\fR   变量给出的某个目录的子目录。如果 \fB$tcl_pkgPath\fR 包含多于一个的目录，依赖于机器的包(例如，包含二进制共享库的包)通常应该被安装在第一个目录下面而不依赖于机器的包(例如，只包含 Tcl  脚本的包)应该被安装在第二个目录下面。子目录应该包含包的脚本和/或二进制文件还有 \fBpkgIndex.tcl\fR  文件。包被安装为在 \fB$tcl_pkgPath\fR   中的一个目录的一个子目录之后，在 \fBpackage require\fR  命令期间可自动找到它。
.br
如果你把包安装在其他地方，则你必须确保包含包的目录在 \fBauto_path\fR 全局变量中或在 \fBauto_path\fR  中的一个目录的最直接(immediate)子目录中。\fBAuto_path\fR包含由自动装载器和包装载器查找的目录的一个列表；缺省的它包括 \fB$tcl_pkgPath\fR。包装载器也检查在 \fBauto_path\fR 中的目录的所有子目录。你可以在你的应用中显式的向 \fBauto_path\fR增加一个目录，或向你的 \fBTCLLIBPATH\fR  环境变量添加这个目录:   如果这个环境变量存在，在应用启动期间Tcl 用它来初始化 \fBauto_path\fR。            
.IP [4]
一旦进行了上述步骤，要使用一个包你需要做的就是调用 \fBpackage require\fR。例如，如果包 \fBTest\fR  的版本 2.1、2.3、和 3.1 已经用 \fBpkg_mkIndex \fR建立了索引，\fBpackage require Test\fR 将可获得版本 3.1 而命令 \fBpackage require -exact Test 2.1\fR将可获得版本 2.1。在 \fBauto_path\fR 中的不同的索引文件中可能有一个包的多个版本，实际上只有一个将被装载到给定的解释器中，具体决定于首先调用了哪个 \fBpackage require\fR。一个包的不同版本可以装载到不同的解释器中。

.SH "选项 OPTIONS"
选项开关有:    
.TP 15
\fB\-direct\fR
The generated index will implement direct loading of the package
upon \fBpackage require\fR.  This is the default.
.TP 15
\fB\-lazy\fR
生成的索引将设法延迟装载包，一直等到使用了由这个包提供命令之一，而不是在 \fBpackage require \fR时立即装载。
.TP 15
\fB\-load \fIpkgPat\fR
索引处理将预装载在当前解释器中现存的所有包和匹配 \fIpkgPat\fR  的包装载到到用于生成索引的从解释器中。模式匹配使用与字符串匹配相同的规则。参见下面的COMPLEX CASES复杂情况。  
.TP 15
\fB\-verbose\fR
在索引处理期间生成输出。输出通过 \fBtclLog\fR    过程，这个过程缺省输出到 stderr。 
.TP 15
\fB\-\-\fR
标志的终止，用于 \fIdir\fR  以连字号开始的情况。 

.SH "包和自动装载器 PACKAGES AND THE AUTO-LOADER"
.PP
包管理设施与自动装载器在一些方面有所重叠，二者都安排文件在需要时(on-demand)装载。但是，包管理是一个高层机制，它在装载过程的最后一步使用自动装载器。一般的，使用\fBpkg_mkIndex\fR  给一个包加索引而不使用 \fBauto_mkindex\fR ，因为包机制提供了版本控制: 在索引文件中可获得一个包的多个版本，急于 \fBpackage require\fR  命令不同的应用可使用不同的版本。相反的，\fBauto_mkindex\fR  不理解版本，所以它只能处理每个包的一个单一版本。对一个给定的包使用   \fBpkg_mkIndex\fR 和 \fBauto_mkindex\fR 两者来建立索引可能不是个好主意。如果你使用 \fBpkg_mkIndex\fR 来为一个包建立索引，它的命令不能被调用，一直等到使用 \fBpackage require\fR 选择了一个版本；相反的，用 \fBauto_mkindex\fR  建立索引的包由于没有版本而可以立即使用。           

.SH "它是如何工作的 HOW IT WORKS"
.PP
\fBPkg_mkIndex\fR 依赖于 \fBpackage unknown\fR  命令、\fBpackage ifneeded\fR 命令、和自动装载器。在第一次调用一个 \fBpackage require\fR命令时，调用 \fBpackage unknown\fR   脚本。Tcl   初始化把它设置成求值在\fBauto_path \fR中的所有 \fBpkgIndex.tcl\fR  文件的一个脚本。\fBpkgIndex.tcl\fR 文件包含给每个可获得的包的 \fBpackage ifneeded\fR 命令；这些命令调用 \fBpackage provide\fR 命令来宣布这个包的可获得性，并且它们设置自动装载器的信息来装载这些包的文件。
.VS 8.3
如果在生成\fBpkgIndex.tcl\fR 时提供了 \fI-lazy\fR  标志，
.VE
在第一次调用它的命令之前不实际上装载一个给定包的给定版本的一个给定文件。所以在调用了 \fBpackage require\fR之后，你可能在这个解释器中不能看到这个包的命令，但你可以调用它的命令而它们将被自动装载。  

.VS 8.3
.SH "直接装载 DIRECT LOADING"
.PP
一些包，例如使用了名字空间和导出命令或要求特殊初始化的包，可以选择在 \fBpackage require\fR 的时候立即装载它们的包文件而不是延迟实际的装载到第一次使用这个包中的命令的时候。在生成包索引时这是缺省的模式。可以指定 \fI-lazy\fR 参数来屏弃(override)它。
.VE

.SH "复杂情况 COMPLEX CASES"
脚本和二进制文件之间存在依赖，和包被分开成脚本和二进制文件的可被正确处理。但是，你可能必须调整\fBpkg_mkIndex\fR  处理这些文件的次序。下面详细描述这些要点。
.PP
如果每个脚本或文件包含一个包，并且包只包含在一个文件中，则事情就很容易。你可以简单的用一些通配符模式指定以任意次序为所有文件建立索引。
.PP
一般的，脚本依赖于其他包是没有问题的。如果脚本包含 \fBpackage require\fR 命令，在用于处理这个脚本的解释器中把他们连根拔除(stubbed out)，所以不会导致问题。如果脚本调用了其他包的在全局代码中的过程，这些调用由一个存根(stub) \fBunknown\fR    命令处理。但是，如果脚本引用了其他包的在全局代码中的变量   ，这将导致错误。这也是糟糕的编码风格。
.PP
如果二进制文件依赖于其他的包，事情就变的棘手了，因为在装载一个二进制文件时不可能连根拔除C-层次 API 如 \fBTcl_PkgRequire\fR API。例如，假设 BLT 包要求 Tk，并在它的 \fBBlt_Init \fR例程中用对 \fBTcl_PkgRequire\fR 的一个调用表达了这种需求。要支持它，你必须在一个已经装载了Tk 的解释器中运行 \fBpkg_mkIndex\fR。你用 \fB-load \fR\fIpkgPat\fR选项来完成这个任务。如果你指定了这个选项，\fBpkg_mkIndex\fR将装载在 \fBinfo loaded\fR 中列出的所有的包和那些匹配 \fIpkgPat\fR 的包到用于处理文件的解释器中。在多数情况下这将可以满足二进制文件中的 \fBTcl_PkgRequire\fR 调用。
.PP
如果你为两个二进制文件建立索引，其中的一个依赖于另一个，你应该最后指定有依赖的那个包。这样没有依赖的那个包将被装载和建立索引，那么在处理第二个文件的时候这个文件所提供的包就是可获得的了。你还必须使用 \fB-load\fR 标志把第一个包装载到用于建立索引的一个临时解释器中；这将无损于指定仍未装载的包模式。
.PP
如果你有一个分开成一些脚本和一个二进制文件的包，则你必须避免 \fB-load\fR    标志。问题在于如果你在计算索引之前装载了一个包，它将屏蔽提供同一个包的其他部分的所有其他文件。如果你必须使用 \fB-load\fR，则你必须首先指定脚本；否则从二进制文件装载的包可能会屏蔽用脚本定义的包。    

.SH "参见 SEE ALSO"
package(n)

.SH "关键字 KEYWORDS"
auto-load, index, package, version

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/09/01 
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
