'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: history.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: history.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH history n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
history \- 操纵历史列表
.SH 总览 SYNOPSIS
\fBhistory \fR?\fIoption\fR? ?\fIarg arg ...\fR?
.BE

.SH 描述 DESCRIPTION
.PP
\fBhistory\fR 命令完成与记录在一个历史列表中的最近执行过的命令有关的一些操作中的一个。每个记录的命令被作为一个“事件”来参照。使用下列形式给 \fBhistory\fR 命令指定的一个事件:
.IP [1]
一个数: 如果是正数，它用这个数来参照事件(所有事件多被从 1 开始计数)。如果是负数，它选择相对当前事件的一个事件(\fB\-1\fR 参照上一个事件，\fB\-2\fR 参照大上一个，以此类推)。事件 \fB0\fP 参照当前事件。
.IP [2]
一个字符串: 选择匹配这个字符串的最新近的事件。在两种情况下一个事件被考虑为匹配这个字符串，要么这个字符串与这个命令的最前面的字符相同，要么这个字符串以与 \fBstring match\fR 命令相同的方式匹配这个事件。
.PP
\fBhistory\fR 命令接受所有下列形式:
.TP
\fBhistory\fR
同于下面描述的 \fBhistory info\fR。
.TP
\fBhistory add\fI command \fR?\fBexec\fR?
把 \fIcommand\fR 参数作为一个新事件添加到历史列表中。如果指定了 \fBexec\fR(或其缩写) 则还执行这个命令并返回它的结果。如果没有指定 \fBexec\fR 则返回一个空串作为结果。
.TP
\fBhistory change\fI newValue\fR ?\fIevent\fR?
把给一个事件记录的值替代(replace)为 \fInewValue\fR。 \fIEvent\fR 指定要替代的事件，缺省为当前 (\fIcurrent\fR) 事件(不是事件 \fB\-1\fR)。这个命令用在实现新形式的历史替换(substitution)的命令中，和用在想用通过替换建立的命令替代当前事件(调用这个替换的事件)的命令中。 返回值是一个空串。
.TP
\fBhistory clear\fR
删除历史列表。保持当前保留限制。重置历史事件数。
.TP
\fBhistory event\fR ?\fIevent\fR?
返回由 \fIevent\fR 给出的事件的值。 \fIEvent\fR 缺省为 \fB\-1\fR。
.TP
\fBhistory info \fR?\fIcount\fR?
返回一个格式化了字符串(用于人们阅读)，它给出在历史列表中除了当前事件之外的每个事件的事件号和内容。如果指定了 \fIcount\fR，则只返回新近的 \fIcount\fR 个事件。
.TP
\fBhistory keep \fR?\fIcount\fR?
使用这个命令来变更历史列表的大小为 \fIcount\fR 个事件。最初，在历史列表中保留 20 个事件。如果未指定 \fIcount\fR ，则返回当前的保留限制。
.TP
\fBhistory nextid\fR
返回要记录在历史记录中的下一个事件的号码。这对象在命令行提示符下输出事件号这样的事有用。
.TP
\fBhistory redo \fR?\fIevent\fR?
重新执行由 \fIevent\fR 指示的命令并返回它的结果。\fIEvent\fR 缺省为 \fB\-1\fR。这个命令导致历史修订: 详情见下面的段落。

.SH "历史修订 HISTORY REVISION"
.PP
8.0 之前 的 Tcl 有一个复杂的历史修订机制。当前的机制受到了更多的限制，并且去除了老的历史操作 \fBsubstitute\fP  和 \fBwords\fP 。(作为安慰，添加了 \fBclear\fP 操作。)
.PP
历史选项 \fBredo\fR 导致非常简单的“历史修订”。在调用这个选项的时候，修改最新近的事件来淘汰历史命令(的记录)并用历史命令的结果替换它。如果你打算重做一个事件而不修改历史列表，则使用 \fBevent\fP 操作来检索某些事件，并使用 \fBadd\fP 操作来向历史列表添加它并执行它。

.SH 关键字 KEYWORDS
event, history, record

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/09/03
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
