/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"
#include "file_utils.h"
#include "map_seeking.h"
#include "menus.h"
#include "game_loop.h"
#include "sounds.h"

#define SK_BUILTINS_X1 32
#define SK_BUILTINS_X2 160
#define SK_BUILTINS_Y1 160
#define SK_BUILTINS_Y2 192

#define SK_CUSTOMS_X1 168
#define SK_CUSTOMS_X2 272
#define SK_CUSTOMS_Y1 160
#define SK_CUSTOMS_Y2 192

#define SK_UP_ARROW_X1 298
#define SK_UP_ARROW_X2 320
#define SK_UP_ARROW_Y1 192
#define SK_UP_ARROW_Y2 214

#define SK_DOWN_ARROW_X1 298
#define SK_DOWN_ARROW_X2 320
#define SK_DOWN_ARROW_Y1 548
#define SK_DOWN_ARROW_Y2 575

#define SK_LAUNCH_X1 642
#define SK_LAUNCH_X2 728
#define SK_LAUNCH_Y1 540
#define SK_LAUNCH_Y2 570

#define SK_BACK_X1 642
#define SK_BACK_X2 728
#define SK_BACK_Y1 482
#define SK_BACK_Y2 512

#define SK_MAPS_BOX_X1 50
#define SK_MAPS_BOX_X2 280
#define SK_MAPS_BOX_Y1 210
#define SK_MAPS_BOX_Y2 570

#define SK_MINIMAP_X 428
#define SK_MINIMAP_Y 428

#define SK_MAPS_SLOT1_X 50
#define SK_MAPS_SLOT1_Y 224
#define SK_MAPS_DELTAY 25

#define SK_DESC_X 432
#define SK_DESC_SLOT1_X 432
#define SK_DESC_SLOT1_Y 215
#define SK_DESC_DELTAY 25

extern player_t *player;
extern game_data_t *world;
extern map_names_t *map_names;
extern char *filename;

skirmish_menu_t *sk_menu;
extern menu_common_t *menu_shared;
map_list_t *builtins_list;
map_list_t *customs_list;
map_list_t *current;
char is_custom_maps = 0;

char need_draw_custom_panel=0;
char can_play_arrow_sound=1;

void read_map_infos(int type, map_list_item_t *map_desc);

const char *skirmish_menu_tex_names[N_SKIRMISH_MENU_TEX] =
  {
    SHXMAN_DATA "menus/skirmish/skirmish_0.png",
    SHXMAN_DATA "menus/skirmish/skirmish_1.png",
    SHXMAN_DATA "menus/skirmish/skirmish_2.png",
    SHXMAN_DATA "menus/skirmish/skirmish_3.png"
  };

enum
  {
    E_SK_DYN_DOWNARROW,
    E_SK_DYN_UPARROW,
    E_SK_DYN_BACK0,
    E_SK_DYN_BACK1,
    E_SK_DYN_LAUNCH0,
    E_SK_DYN_LAUNCH1,

    E_SK_DYN_PANEL0,
    E_SK_DYN_PANEL1,
    E_SK_DYN_PANEL2,
    E_SK_DYN_PANEL3
  };

const char *skirmish_menu_dyn_tex_names[N_SKIRMISH_MENU_DYN_TEX] =
  {
    SHXMAN_DATA "menus/skirmish/arrow_down.png",
    SHXMAN_DATA "menus/skirmish/arrow_up.png",
    SHXMAN_DATA "menus/skirmish/back_0.png",
    SHXMAN_DATA "menus/skirmish/back_1.png",
    SHXMAN_DATA "menus/skirmish/launch_0.png",
    SHXMAN_DATA "menus/skirmish/launch_1.png",

    SHXMAN_DATA "menus/skirmish/panel_0.png",
    SHXMAN_DATA "menus/skirmish/panel_1.png",
    SHXMAN_DATA "menus/skirmish/panel_2.png",
    SHXMAN_DATA "menus/skirmish/panel_3.png"
  };

void load_menu_skirmish()
{
  int i=0; int name_size=0;
  sk_menu = new skirmish_menu_t;
  SDL_Surface *images_skirmish[N_SKIRMISH_MENU_TEX];
  SDL_Surface *images_skirmish_dyn[N_SKIRMISH_MENU_DYN_TEX];

  glGenTextures(N_SKIRMISH_MENU_TEX, sk_menu->tex_menu);
  for (i=0; i<N_SKIRMISH_MENU_TEX; i++)
    {
      images_skirmish[i] = ImageLoad(skirmish_menu_tex_names[i]);
      
      glBindTexture(GL_TEXTURE_2D, sk_menu->tex_menu[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);      
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);      

      glTexImage2D(GL_TEXTURE_2D, 0,3, images_skirmish[i]->w, images_skirmish[i]->h,0,
                      GL_RGB, GL_UNSIGNED_BYTE, images_skirmish[i]->pixels);

      SDL_FreeSurface(images_skirmish[i]);
    }

  glGenTextures(N_SKIRMISH_MENU_DYN_TEX, sk_menu->tex_dyn_menu);
  for (i=0; i<N_SKIRMISH_MENU_DYN_TEX; i++)
    {
      images_skirmish_dyn[i] = ImageLoad(skirmish_menu_dyn_tex_names[i]);
      
      glBindTexture(GL_TEXTURE_2D, sk_menu->tex_dyn_menu[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
      
      glTexImage2D(GL_TEXTURE_2D, 0,3, images_skirmish_dyn[i]->w, images_skirmish_dyn[i]->h,0, GL_RGB, GL_UNSIGNED_BYTE, images_skirmish_dyn[i]->pixels);

      SDL_FreeSurface(images_skirmish_dyn[i]);
    }

  sk_menu->mat_amb_diff[0] = 0.937;
  sk_menu->mat_amb_diff[1]= 0.937;
  sk_menu->mat_amb_diff[2] = 0.937;
  sk_menu->mat_amb_diff[3] = 1.0;

  builtins_list = new map_list_t;
  builtins_list->pos_x = SK_MAPS_SLOT1_X;
  builtins_list->pos_y = SK_MAPS_SLOT1_Y;
  builtins_list->num_items_total = map_names->num_builtins;
  builtins_list->max_items = SK_LIST_MAX_ITEMS;
  builtins_list->items = new map_list_item_t [map_names->num_builtins];

  for (i=0; i<builtins_list->num_items_total; i++)
    {
      name_size = strlen(map_names->builtins[i]);
      builtins_list->items[i].text = new char [name_size +1];
      strcpy(builtins_list->items[i].text,map_names->builtins[i]);
      builtins_list->items[i].slot = i;
      builtins_list->items[i].map_size=-1;
      builtins_list->items[i].map_world=-1;
      builtins_list->items[i].map_time_limit=-1;
      builtins_list->items[i].map_num_huts=-1;
      builtins_list->items[i].map_num_shmolluxes=-1;
      builtins_list->items[i].map_num_lives=-1;
      builtins_list->items[i].map_winning_square=-1;
      builtins_list->items[i].is_minimap_loaded=0;
    }
  builtins_list->selected_slot = 0;
  builtins_list->selected_item = 0;

  read_map_infos (SK_LIST_BUILTINS, &builtins_list->items[0]);
  load_minimap_for_menu (SK_LIST_BUILTINS, &builtins_list->items[0]);

  customs_list = new map_list_t;
  customs_list->pos_x = SK_MAPS_SLOT1_X;
  customs_list->pos_y = SK_MAPS_SLOT1_Y;
  customs_list->num_items_total = map_names->num_customs;
  customs_list->max_items = SK_LIST_MAX_ITEMS;
  if (customs_list->num_items_total) {
    customs_list->items = new map_list_item_t [customs_list->num_items_total];
    is_custom_maps = 1;

    for (i=0; i<customs_list->num_items_total; i++)
      {
	name_size = strlen(map_names->customs[i]);
	customs_list->items[i].text = new char [name_size +1];
	strcpy(customs_list->items[i].text,map_names->customs[i]);
	customs_list->items[i].slot = i;
	customs_list->items[i].map_size=-1;
	customs_list->items[i].map_world=-1;
	customs_list->items[i].map_time_limit=-1;
	customs_list->items[i].map_num_shmolluxes=-1;
	customs_list->items[i].map_num_huts=-1;
	customs_list->items[i].map_winning_square=-1;
	customs_list->items[i].is_minimap_loaded=0;
      }
      customs_list->selected_slot = 0;
      customs_list->selected_item = 0;

      read_map_infos (SK_LIST_CUSTOMS, &customs_list->items[0]);
      load_minimap_for_menu (SK_LIST_CUSTOMS, &customs_list->items[0]);
  }
  else is_custom_maps = 0;

  sk_menu->active_list = SK_LIST_BUILTINS;
  current = builtins_list;

  sk_reset_draw_needs();
}

void cleanup_menu_skirmish()
{
  int i=0;
  map_list_item_t *map_desc;
  glDeleteTextures(N_SKIRMISH_MENU_TEX,sk_menu->tex_menu);
  glDeleteTextures(N_SKIRMISH_MENU_DYN_TEX,sk_menu->tex_dyn_menu);

  for (i=0; i < builtins_list->num_items_total; i++)
    {
      map_desc = &builtins_list->items[i];
      if (map_desc->is_minimap_loaded) 
	glDeleteTextures(1,&map_desc->minimap);
    }

  if (customs_list->num_items_total) {
    for (i=0; i < customs_list->num_items_total; i++)
    {
      map_desc = &customs_list->items[i];
      if (map_desc->is_minimap_loaded) 
	glDeleteTextures(1,&map_desc->minimap);
    }
  }

  delete builtins_list;
  delete customs_list;

  delete sk_menu;
}

void draw_skirmish_menu_static()
{
  GLfloat x = 0, y=600; int i=0;
  glPushMatrix();

  for (i=0; i < N_SKIRMISH_MENU_TEX; i++)
    {
      if (i == 2) x+=400;
      if (i==0 || i== 2) y=600; else y=300;

      glBindTexture(GL_TEXTURE_2D,sk_menu->tex_menu[i]);
      glBegin(GL_QUADS);

      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-300);
      glTexCoord2f(1, 0);
      glVertex2f(x+400,y-300);
      glTexCoord2f(1, 1);
      glVertex2f(x+400, y);

      glEnd();
    }
}

void draw_skirmish_menu_maps()
{
  int i=0;
  GLfloat text_y;
  glLineWidth(0.5);
  //glDisable(GL_TEXTURE_2D);

  if (current == builtins_list && need_draw_custom_panel)
    {
      menu_shared->tgaFont.SetSize(12);
      menu_shared->tgaFont.Color3f(0.1, 0.1, 0.1);
      text_y = 600-SK_MAPS_SLOT1_Y;
      menu_shared->tgaFont.Draw(SK_MAPS_SLOT1_X,text_y , "No map available");
    }

  else {
  for (i=0; i < current->num_items_total; i++)
    {
      if ((current->items[i].slot >= 0)&&(current->items[i].slot <= current->max_items)) {
	menu_shared->tgaFont.SetSize(12);
	if (current->items[i].slot == current->selected_slot)
	  menu_shared->tgaFont.Color3f(0.1, 0.1, 0.9);
	else menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
	text_y = 600-SK_MAPS_SLOT1_Y -current->items[i].slot*SK_MAPS_DELTAY;
	menu_shared->tgaFont.Draw(SK_MAPS_SLOT1_X,text_y , -2,current->items[i].text);

	// glColor3f(1.0,1.0,0.0);
 	// glBegin(GL_LINES);
//  	glColor3f(1.0,1.0,0.0);
//  	glVertex2f(0,text_y-10);
//  	glVertex2f(800,text_y-10);
//  	glEnd();

      }
    }
  }

 // glEnable(GL_TEXTURE_2D);

}

void menu_skirmish_down_arrow_pressed()
{
  int i=0;

  if (current == builtins_list && need_draw_custom_panel)
    {

    }
  else {
    if (current->items[current->num_items_total-1].slot > current->max_items) {
      for (i=0; i < current->num_items_total; i++)
	{
	  current->items[i].slot--;
	}
    
      if (current->selected_slot > 0) current->selected_slot--;
    }

    /* nothing to see */
    else 
      {
	if (can_play_arrow_sound) {
	  play_menu_sound(MENU_SOUND_ARROW);
	  can_play_arrow_sound=0;
	}
      }
  }
  sk_menu->need_draw_down=1;
}

void menu_skirmish_up_arrow_pressed()
{
  int i=0;
  if (current == builtins_list && need_draw_custom_panel)
    {

    }
  else {
    if (current->items[0].slot < 0) {
      for (i=0; i < current->num_items_total; i++)
	{
	  current->items[i].slot++;
	}
    
      if (current->selected_slot< current->max_items) current->selected_slot++;
    }

    /* nothing to see */
    else 
      {
	if (can_play_arrow_sound) {
	  play_menu_sound(MENU_SOUND_ARROW);
	  can_play_arrow_sound=0;
	}
      }
  }
  sk_menu->need_draw_up=1;
}

void draw_skirmish_menu_mouseover()
{
  if (sk_menu->need_draw_up) draw_skirmish_uparrow_active();
  if (sk_menu->need_draw_down) draw_skirmish_downarrow_active();
  if (sk_menu->need_draw_launch) draw_skirmish_launch_active();
  if (sk_menu->need_draw_back) draw_skirmish_back_active();

  if (need_draw_custom_panel) draw_skirmish_custompanel_active();
}

void draw_skirmish_menu()
{
  set_GL_projection (MANGO_2D);
  set_GL_options (MANGO_2D);
  glClear(GL_COLOR_BUFFER_BIT);// | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();

  glPushMatrix();
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, sk_menu->mat_amb_diff);

  glEnable(GL_TEXTURE_2D);

  /* first we draw static elements of the menu */
  draw_skirmish_menu_static();

  /* draw lighted elements on mouse-over */
  draw_skirmish_menu_mouseover();

  /* draw maps lists */
  draw_skirmish_menu_maps();

  /* draw selected map description and minimap */
  draw_skirmish_menu_selected_map_infos();
  draw_skirmish_menu_selected_map_minimap();

  /* then we draw the cursor */
  draw_cursor();

  glDisable(GL_TEXTURE_2D);
  glPopMatrix();
  SDL_GL_SwapBuffers();
}

void skirmish_menu_loop()
{
  sk_menu->loop_end = 0;

  while (!(sk_menu->loop_end))
  {
    {
      SDL_Event event;
      
      while (SDL_PollEvent(&event))
	{
	  if (event.type == SDL_KEYDOWN)
	    {
	      switch (event.key.keysym.sym)
		{
		case SDLK_ESCAPE:
		  play_menu_sound(MENU_SOUND_BACK);
		  sk_menu->loop_end = 1;
		  break;
		  
		default:
		  break;
		}
	    }
	  
	  if (event.type == SDL_MOUSEBUTTONDOWN)
	    {
	      menu_shared->is_button_down=1;
	    }

	  if (event.type == SDL_MOUSEBUTTONUP)
	    {
	      menu_shared->is_button_down=0;
	      can_play_arrow_sound=1;
	    }
	}
    }
    SDL_GetMouseState(&menu_shared->mouse_x,&menu_shared->mouse_y);
    if (menu_shared->is_button_down)
      analyze_skirmish_menu_buttondown(&sk_menu->loop_end);

    analyze_skirmish_menu_hoover();

    draw_skirmish_menu();
    sk_reset_draw_needs();
  }
  glFlush();
}

void analyze_skirmish_menu_buttondown(int *loop_flag)
{
  int i=0;
  if ((menu_shared->mouse_x >= SK_MAPS_BOX_X1) && (menu_shared->mouse_x < SK_MAPS_BOX_X2)
      && (menu_shared->mouse_y >= SK_MAPS_BOX_Y1) && (menu_shared->mouse_y < SK_MAPS_BOX_Y2))
    {
      analyze_skirmish_bouttondown_on_map();
    }

  if ((menu_shared->mouse_x >= SK_BUILTINS_X1) && (menu_shared->mouse_x < SK_BUILTINS_X2)
      && (menu_shared->mouse_y >= SK_BUILTINS_Y1) && (menu_shared->mouse_y < SK_BUILTINS_Y2))
    {
      sk_menu->active_list = SK_LIST_BUILTINS;
      current = builtins_list;
      need_draw_custom_panel = 0;
    }

  if ((menu_shared->mouse_x >= SK_CUSTOMS_X1) && (menu_shared->mouse_x < SK_CUSTOMS_X2)
      && (menu_shared->mouse_y >= SK_CUSTOMS_Y1) && (menu_shared->mouse_y < SK_CUSTOMS_Y2))
    {
      sk_menu->active_list = SK_LIST_CUSTOMS;
      if (customs_list->num_items_total) current = customs_list;
      else current = builtins_list;
      need_draw_custom_panel = 1;
    }

  if ((menu_shared->mouse_x >= SK_LAUNCH_X1) && (menu_shared->mouse_x < SK_LAUNCH_X2)
      && (menu_shared->mouse_y >= SK_LAUNCH_Y1) && (menu_shared->mouse_y < SK_LAUNCH_Y2))
    {
      i=current->selected_item;
      play_menu_sound(MENU_SOUND_LAUNCH);
      menu_skirmish_launch_pressed(sk_menu->active_list,&current->items[i]);
      menu_shared->is_button_down=0;
      
    }

  if ((menu_shared->mouse_x >= SK_BACK_X1) && (menu_shared->mouse_x < SK_BACK_X2)
      && (menu_shared->mouse_y >= SK_BACK_Y1) && (menu_shared->mouse_y < SK_BACK_Y2))
    {
      *loop_flag = 1;
      play_menu_sound(MENU_SOUND_BACK);
      menu_shared->is_button_down=0;
    }

  if ((menu_shared->mouse_x >= SK_DOWN_ARROW_X1) && (menu_shared->mouse_x < SK_DOWN_ARROW_X2)
      && (menu_shared->mouse_y >= SK_DOWN_ARROW_Y1) && (menu_shared->mouse_y < SK_DOWN_ARROW_Y2))
    {
      menu_skirmish_down_arrow_pressed();
    }

  if ((menu_shared->mouse_x >= SK_UP_ARROW_X1) && (menu_shared->mouse_x < SK_UP_ARROW_X2)
      && (menu_shared->mouse_y >= SK_UP_ARROW_Y1) && (menu_shared->mouse_y < SK_UP_ARROW_Y2))
    {
      menu_skirmish_up_arrow_pressed();
    }

}

void analyze_skirmish_menu_hoover()
{
  if ((menu_shared->mouse_x >= SK_LAUNCH_X1) && (menu_shared->mouse_x < SK_LAUNCH_X2)
      && (menu_shared->mouse_y >= SK_LAUNCH_Y1) && (menu_shared->mouse_y < SK_LAUNCH_Y2))
    {
      sk_menu->need_draw_launch=1;
    }

if ((menu_shared->mouse_x >= SK_BACK_X1) && (menu_shared->mouse_x < SK_BACK_X2)
      && (menu_shared->mouse_y >= SK_BACK_Y1) && (menu_shared->mouse_y < SK_BACK_Y2))
    {
      sk_menu->need_draw_back=1;
    }
}

void analyze_skirmish_bouttondown_on_map()
{
  int i=0;
  GLfloat y1=0, y2=0;

  if (current == builtins_list && need_draw_custom_panel)
    {

    }
  else {

       for (i=0; i < current->num_items_total; i++)
	{
	  if ((current->items[i].slot >= 0)&&(current->items[i].slot <= current->max_items)) {
	    y1= SK_MAPS_SLOT1_Y+current->items[i].slot*SK_MAPS_DELTAY + 10;
	    y2 = SK_MAPS_SLOT1_Y+(current->items[i].slot-1)*SK_MAPS_DELTAY +10 ;
	    
	    if ((menu_shared->mouse_y >= y2 ) && (menu_shared->mouse_y < y1))
	      {
		current->selected_item = i;
		current->selected_slot = current->items[i].slot;
		if (current->items[i].map_size < 0)
		  read_map_infos (sk_menu->active_list,&current->items[i]); 
		if (current->items[i].is_minimap_loaded==0)
		  load_minimap_for_menu(sk_menu->active_list,&current->items[i]);
		
	      }
	  }
	}
  }
}

void draw_skirmish_menu_selected_map_minimap()
{
  int i=0;
  if (current == customs_list && current->num_items_total == 0)
    i=builtins_list->selected_item;
  else i = current->selected_item;

  glDisable(GL_BLEND);
  glEnable(GL_TEXTURE_2D);
  glPushMatrix();
  glBindTexture(GL_TEXTURE_2D,current->items[i].minimap);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(SK_MINIMAP_X, 600-SK_MINIMAP_Y-140);

  glTexCoord2f(1, 0);
  glVertex2f(SK_MINIMAP_X+140, 600-SK_MINIMAP_Y-140);

  glTexCoord2f(1,1);
  glVertex2f(SK_MINIMAP_X+140, 600-SK_MINIMAP_Y);

  glTexCoord2f(0,1);
  glVertex2f(SK_MINIMAP_X,600-SK_MINIMAP_Y) ;

  glEnd();
  glEnable(GL_BLEND);
  glPopMatrix();
}

void draw_skirmish_menu_selected_map_infos()
{
  int i=0;
  char *world_names[]=
  {
    "industrial","carribean","mines","mangoland"
  };

  GLfloat text_y=0;
  menu_shared->tgaFont.SetSize(12);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  text_y = 600-SK_DESC_SLOT1_Y;

  if (current == customs_list && current->num_items_total == 0)
    i=builtins_list->selected_item;
  else i = current->selected_item;

  menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y , "Size: %dx%d",current->items[i].map_size,current->items[i].map_size);
  
  menu_shared->tgaFont.SetSize(12);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y-SK_DESC_DELTAY , "World: %s",world_names[current->items[i].map_world]);

  menu_shared->tgaFont.SetSize(12);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);

  if (current->items[i].map_time_limit)
    menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y-2*SK_DESC_DELTAY , "Time limit: %d seconds",current->items[i].map_time_limit);
  else menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y-2*SK_DESC_DELTAY , "Time limit: no limit");

  /*menu_shared->tgaFont.SetSize(12);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y-3*SK_DESC_DELTAY , "Number of huts: %d",current->items[i].map_num_huts);*/

  menu_shared->tgaFont.SetSize(12);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y-3*SK_DESC_DELTAY , "Number of shmolluxes: %d",current->items[i].map_num_shmolluxes);

  menu_shared->tgaFont.SetSize(12);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y-4*SK_DESC_DELTAY , "Number of lives: %d",current->items[i].map_num_lives);

  menu_shared->tgaFont.SetSize(12);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(SK_DESC_SLOT1_X,text_y-5*SK_DESC_DELTAY , "Winning post: %s",(current->items[i].map_winning_square>=0)?"yes":"no");

}


void draw_skirmish_launch_active()
{
  GLfloat x=0, y=0;
  x=SK_LAUNCH_X1-18;
  y=600-SK_LAUNCH_Y1+12;

  glPushMatrix();
  glDisable(GL_BLEND);
  
  for (int i=E_SK_DYN_LAUNCH0; i <E_SK_DYN_LAUNCH1+1; i++)
    {
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,sk_menu->tex_dyn_menu[i]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-64);
      glTexCoord2f(1, 0);
      glVertex2f(x+64,y-64);
      glTexCoord2f(1, 1);
      glVertex2f(x+64, y);
      
      glEnd();

      x+=64;
    }

  glEnable(GL_BLEND);
  glPopMatrix();
}

void draw_skirmish_back_active()
{
  GLfloat x=0, y=0;
  x=SK_BACK_X1-18;
  y=600-SK_BACK_Y1+18;

  glPushMatrix();
  glDisable(GL_BLEND);
  
  for (int i=E_SK_DYN_BACK0; i <E_SK_DYN_BACK1+1; i++)
    {
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,sk_menu->tex_dyn_menu[i]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-64);
      glTexCoord2f(1, 0);
      glVertex2f(x+64,y-64);
      glTexCoord2f(1, 1);
      glVertex2f(x+64, y);
      
      glEnd();

      x+=64;
    }

  glEnable(GL_BLEND);
  glPopMatrix();
}

void draw_skirmish_custompanel_active()
{
  GLfloat x=0, y=0;
  x=SK_BUILTINS_X1;
  y=600-SK_BUILTINS_Y1;

  glPushMatrix();
  glDisable(GL_BLEND);
  
  for (int i=E_SK_DYN_PANEL0; i <E_SK_DYN_PANEL3+1; i++)
    {
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,sk_menu->tex_dyn_menu[i]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-64);
      glTexCoord2f(1, 0);
      glVertex2f(x+64,y-64);
      glTexCoord2f(1, 1);
      glVertex2f(x+64, y);
      
      glEnd();

      x+=64;
    }

  glEnable(GL_BLEND);
  glPopMatrix();

}

void draw_skirmish_uparrow_active()
{
  GLfloat x=0, y=0;
  x=SK_UP_ARROW_X1-2;
  y=600-SK_UP_ARROW_Y1;

  glPushMatrix();
  glDisable(GL_BLEND);
  
  glBindTexture(GL_TEXTURE_2D,sk_menu->tex_dyn_menu[E_SK_DYN_UPARROW]);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  
  glEnd();

  glEnable(GL_BLEND);
  glPopMatrix();
}

void draw_skirmish_downarrow_active()
{
  GLfloat x=0, y=0;
  x=SK_DOWN_ARROW_X1-10;
  y=600-SK_DOWN_ARROW_Y1+4;

  glPushMatrix();
  glDisable(GL_BLEND);
  glBindTexture(GL_TEXTURE_2D,sk_menu->tex_dyn_menu[E_SK_DYN_DOWNARROW]);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  
  glEnd();

  glEnable(GL_BLEND);
  glPopMatrix();
}

void sk_reset_draw_needs()
{
  sk_menu->need_draw_up=0;
  sk_menu->need_draw_down=0;
  sk_menu->need_draw_launch=0;
  sk_menu->need_draw_back=0;
}

void load_minimap_for_menu(int type, map_list_item_t *map_desc)
{
  char *i_minimap; 
  char path[MAX_PATH];
  memset (path,0,(MAX_PATH-1)*sizeof(char));

  //printf("Loading map preview for %s\n",map_desc->text);

  int tFichier = strlen(map_desc->text);
  i_minimap = new char[tFichier+1];
  strcpy(i_minimap,map_desc->text );
  i_minimap[tFichier-1] = 'p';

  if (type == SK_LIST_BUILTINS)
    map_name_to_builtin_path(i_minimap,path);

  else map_name_to_custom_path(i_minimap,path);

  LoadTexture(path, &map_desc->minimap);
  map_desc->is_minimap_loaded=1;
  delete [] i_minimap;
}

void menu_skirmish_launch_pressed(int type, map_list_item_t *map_desc)
{
  char path[MAX_PATH];
  memset (path,0,(MAX_PATH-1)*sizeof(char)); 

  if (type == SK_LIST_BUILTINS) {
    map_name_to_builtin_path(map_desc->text,path);
  }

  else map_name_to_custom_path(map_desc->text,path);

  strcpy(filename,path);

  printf("--> Preparing to launch map %s\n",filename);

  while (world->need_to_restart_map) {
    load_map(filename);
    mainLoop();
    unload_map();
  }
  world->need_to_restart_map=1;
}
