/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _HUD_H
#define _HUD_H

#include "font.h"


#define MINIMAP_PETITE 1
#define MINIMAP_GRANDE 2
#define MINIMAP_ENORME 3
#define MINIMAP_OFF 4

#define N_TEXTURES_BARRE 32

#define PIC_MINIMAP_W 128
#define PIC_MINIMAP_H 128

#define PIC_COMPAS_W 128
#define PIC_COMPAS_H 128
#define COMPAS_W 100
#define COMPAS_H 100

#define VIE_W 32
#define VIE_H 32

#define PETITE_INTERF 32
#define GRANDE_INTERF 64

#define PIC_POS_J_W 32
#define PIC_POS_J_H 32

#define MAX_HUD_MESSAGES 5
#define MESSAGE_TIME 30 //time in seconds before switching messages
#define MAX_MESSAGE_LENGTH 100 //characters

struct hud_message_t
{
  CHRONOMETRE *timer;
  int pos_y;
  char *text_message;

  char is_active;
  int slot;
};

struct hud_t
{
  GLfloat mat_amb_diff[4];

  GLuint t_minimap;
  GLuint t_fakeMinimap;
  GLuint t_mask_minimap;
  GLuint t_aiguille;
  GLuint t_mask_aiguille;
  GLuint t_vie;
  GLuint t_mask_vie;
  GLuint t_posJoueur;
  GLuint t_posShmollux;
  GLuint t_posBoite;
  GLuint t_posBonus;
  GLuint t_posGomme;
  GLuint t_mask_boussole_socle;
  GLuint t_boussole_socle;
  
  GLuint t_barre_gauche;
  GLuint t_barre_gauche_mask;
  GLuint t_barre_milieu1;
  GLuint t_barre_milieu1_mask;
  GLuint t_barre_milieu2;
  GLuint t_barre_milieu2_mask;
  GLuint t_barre_droite;
  GLuint t_barre_droite_mask;

  GLuint *t_barre;
  GLuint *t_Bstocks;

  GLint listeGrandCarre;
  GLint listePetitCarre;

  float MINIMAP_W, MINIMAP_H;
  font_t tgaFont[2];

  hud_message_t *messages;
  int num_messages;
  int last_message;

  char draw_bigminimap;
};

int load_hud();
void cleanup_hud();

void load_mm_textures();
void load_map_minimap_only();
void unload_map_minimap_only();
void load_bottom_bar();
void load_hud_icons();
void load_compas();

void draw_bottom_bar();
void draw_stocks();

void draw_full_minimap();
void draw_mm_background();
void draw_mm_player();
void draw_mm_bonus();
void draw_mm_shmollux();

void draw_compas();
void draw_lives();
void draw_active_bonus();
void draw_message_box();

void draw_HUD();

void draw_waiting();
void draw_dead();
void draw_pause();
void draw_gameover();
void draw_you_win();

void hud_update_messages();
int hud_new_message(char *text);
void hud_delete_message(int number);
void hud_toggle_pause_messages();
void hud_delete_all_messages();

void draw_big_hud_map();
void draw_big_hud_map_cross(GLfloat cross_center_x, GLfloat cross_center_z);
void draw_big_hud_map_losange(GLfloat center_x, GLfloat center_z);
void draw_big_hud_map_triangle(GLfloat center_x, GLfloat center_z);
void draw_big_hud_map_arrow(GLfloat center_x, GLfloat center_z);
void draw_big_hud_map_walls_and_bonus();
void draw_big_hud_map_player();
void draw_big_hud_map_shmolluxes();

#endif
