/* This file is part of the KDE project
   Copyright (C) 2006 KovoKs <info@kovoks.nl>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef SETUP_H
#define SETUP_H

// KDE includes.

#include <kdialogbase.h>

namespace Mailody {

class SetupPriv;

/**
 * @class Setup
 * This class manages the dialog chown in which the user
 * can make all the necessary settings. Each part of the config
 * is located in separate files, See SetupGeneral and SetupTimings
 * for example
 * This file is originally copied from showfoto
 * @author Gilles Caulier <caulier.gilles@free.fr>
 * @author Tom Albers <tomalbers@kde.nl>
 */
class Setup : public KDialogBase
{
    Q_OBJECT

public:

    /**
     * Constructor
     * @param parent Parent Widget
     * @param name Name
     */
    Setup(QWidget* parent=0, const char* name=0);

    /**
     * Destructor
     */
    ~Setup();

private:

    SetupPriv        *d;

private slots:

    void slotOkClicked();
};

}

#endif  /* SETUP_H  */
