/* This file is part of the KDE project
   Copyright (C) 2006 KovoKs <info@kovoks.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <dcopref.h>
#include <kstartupinfo.h>
#include <kdebug.h>
#include <kuniqueapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "mainwindow.h"

/**
 * @class MailodyApplication
 * @author Tom Albers <tomalbers@kde.nl>
 * This class is a simple inheritance from KUniqueApplication
 * the reason that it is reimplemented is so mailto's will work
 * even when mailody is already running.
 */
class MailodyApplication : public KUniqueApplication {
    public:
        /**
         * Similar to KUniqueApplication::newInstance, only without
         * the call to raise the widget when a second instance is started.
         */
        int newInstance()
        {
            KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
            if (args)
            {
                bool compose = false;
                bool attach = false;
                QString sComposeArgs;
                QString sAttachArgs;
                if(args->isSet("compose"))
                {
                    QCStringList cArgLst = args->getOptionList("compose");
                    if(!cArgLst.isEmpty())
                    {
                        compose = true;
                        for(QCStringList::Iterator ite = cArgLst.begin();
                            ite != cArgLst.end();
                            ++ite)
                            if(!(*ite).isEmpty())
                                sComposeArgs.append(
                                    QString::fromLocal8Bit(*ite) + ",");
                    }
                    kdDebug() << "sComposeArgs: " << sComposeArgs << endl;
                }

                if(args->isSet("attach"))
                {
                    QCStringList aArgLst = args->getOptionList("attach");
                    if(!aArgLst.isEmpty())
                    {
                        attach = true;
                        for(QCStringList::Iterator ite = aArgLst.begin();
                            ite != aArgLst.end();
                            ++ite)
                            if(!(*ite).isEmpty())
                                sAttachArgs.append(
                                    QString::fromLocal8Bit(*ite) + ";;");
                    }
                    kdDebug() << "sAttachArgs: " << sAttachArgs << endl;
                }

                if(compose || attach)
                {
                    DCOPRef dcop("mailody", "actions");
                    dcop.call("compose", sComposeArgs, sAttachArgs);
                }

                for(int i=0; i < args->count(); i++)
                {
                    QString ar = args->arg(i);
                    kdDebug() << "Found: " << ar << endl;
                    if (ar.startsWith("mailto:") || ar.contains("@") == 1)
                    {
                        DCOPRef execute( "mailody", "actions" );
                        execute.call("mailTo", ar);
                    }
                }
            }
            return  KUniqueApplication::newInstance();;
        }
};

int main( int argc, char *argv[] )
{
    KAboutData aboutData( "mailody",
                          I18N_NOOP("Mailody"),
                          "0.5.0",
                          I18N_NOOP("An IMAP mail client"),
                          KAboutData::License_GPL,
                          "(c) 2006-2007 KovoKs & Frode M. Døving",
                          0,
                          "http://www.mailody.net");

    aboutData.addAuthor( "Tom Albers", I18N_NOOP("Maintainer and Author"),
                         "tomalbers@kde.nl", "http://www.omat.nl");
    aboutData.addAuthor( "Frode M. Døving",  I18N_NOOP("Author"),
                         "frode@lnix.net");
    aboutData.addCredit( "Achim Bohnet", I18N_NOOP("Packaging and Testing"),
                         "ach@mpe.mpg.de");
    aboutData.addCredit( "Marijke Verkaik", I18N_NOOP("Website and icons"),
                         "internet@kovoks.nl");
    aboutData.addCredit( "Lee Olson", I18N_NOOP("Logo"),
                         "clearbeast@gmail.com");
    aboutData.addCredit( "Maxilys and Kolum",
                         I18N_NOOP("Idea to call this application Mailody"));
    aboutData.addCredit( "Jörn Ahrens", I18N_NOOP("Sidebar in the composer"),
                         "joern.ahrens@kdemail.net");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineOptions cmdline[] =
    {
        { "compose <email>", I18N_NOOP("Open a composer with <email> as recipient"), 0 },
        { "attach <file>", I18N_NOOP("Open a composer with <file> attached."), 0 },
        { "+[email]", I18N_NOOP("Send a message to that address"), 0  },
        KCmdLineLastOption
    };

    KCmdLineArgs::addCmdLineOptions( cmdline );

    if (!KUniqueApplication::start())
    {
        KStartupInfo::handleAutoAppStartedSending();
        fprintf(stderr, "Mailody is already running!\n");
        exit(0);
    }

    MailodyApplication a;

    Mailody::MainWindow* mailody = new Mailody::MainWindow();
    a.setMainWidget(mailody);
    mailody->show();

    return a.exec();
}
