// $Id: Result.java,v 1.1 2002/04/25 18:19:04 bill Exp $

package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;

/**
 * the place where a transformer sends its results
 */
public interface Result
{
    /**
     *
     */
    void characters(String str) throws XSLException;

    /**
     *
     */
    void rawCharacters(String str) throws XSLException;


    /**
     * (NB) The nsMap must declare the prefix on elementType correctly.
     */
    void startElement(Name elementType,
                      NamespacePrefixMap nsMap) throws XSLException;

    /**
     *
     */
    void endElement(Name elementType) throws XSLException;

    /**
     *
     */
    void comment(String str) throws XSLException;

    /**
     *
     */
    void processingInstruction(String target, String data) throws XSLException;

    /**
     *
     */
    void attribute(Name name, String value) throws XSLException;

    /**
     *
     */
    void start(OutputMethod outputMethod) throws XSLException;

    /**
     *
     */
    void end() throws XSLException;

    /**
     *
     */
    Result createResult(String uri) throws XSLException;

    /**
     *
     */
    void message(Node node, String str) throws XSLException;
}
