/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

ListCmdInfo *WX11_ListCmdFirst (int Mode, ListCmdInfo *ListCmd)
{
	static ListCmdInfo *Prima=NULL;
	if (Mode)
		Prima=ListCmd;

	return (Prima);
}

ListCmdInfo *WX11_ListCmdLast (int Mode, ListCmdInfo *ListCmd)
{
	static ListCmdInfo *Ultima=NULL;
	if (Mode)
		Ultima=ListCmd;

	return (Ultima);
}

void WX11_ListCmdFreeItem (ListCmdInfo *ListCmd, ListCmdItemInfo *Item)
{
	//
	// Libera ListCmdItem
	//
	char *Buff;
	if (!ListCmd || !Item) return;


	if (Item->Prev) 
		(Item->Prev)->Next=Item->Next; 
	else 
		ListCmd->PrimoItem=Item->Next;
	if (Item->Next) 
		(Item->Next)->Prev=Item->Prev; 
	else
		ListCmd->UltimoItem=Item->Prev;

	(ListCmd->NumeroItem)--;

	//
	//FreeCom (item->comando);
	if (Item->extra) free (Item->extra); //$$max
	Buff=Item->Buff;
	free (Item);
	free (Buff); 
	
}

void WX11_ListCmdFree (ListCmdInfo *ListCmd)
{
	//
	// Libera la ListCmd e ListCmdItem
	//
	ListCmdItemInfo *Next=NULL;
	ListCmdItemInfo *Item=NULL;
	int NumeroItem=0;
	int x=0;

	if (!ListCmd) return;
	
	NumeroItem=ListCmd->NumeroItem;
	Item=ListCmd->UltimoItem;

	for (x=NumeroItem;x;x--)
	{
		Next=Item->Prev;
		WX11_ListCmdFreeItem (ListCmd,Item);
		Item=Next;
	}

	if (ListCmd->Prev) (ListCmd->Prev)->Next=ListCmd->Next; else 
	WX11_ListCmdFirst (1,ListCmd->Next);
	if (ListCmd->Next) (ListCmd->Next)->Prev=ListCmd->Prev; else
	WX11_ListCmdLast (1,ListCmd->Prev);

	free (ListCmd);
}

void WX11_ListCmdFreeUnused ()
{
    //
    // Free not used ListCmds
    //
    ListCmdInfo *Next=NULL;
    ListCmdInfo *ListCmd=WX11_ListCmdLast(0,NULL);
    CmdInfo *cmd;

    while (ListCmd)
    {
        Next=ListCmd->Prev;

        cmd=(ListCmd->CmdOpen) ? ListCmd->CmdOpen : ListCmd->CmdPar;

        if (!IsComando(cmd))
        {
            // Elimina solo se il comando
            // non esiste piu'
            //printf ("Freee UnusedListCmd (%s)\n",ListCmd->Name);
            WX11_ListCmdFree (ListCmd);
        }
        ListCmd=Next;
    }
}

ListCmdItemInfo *WX11_ListCmdItemAdd (ListCmdInfo *ListCmd, int Tipo,char *Buff)
{
	//
	// Aggiunge Item Al ListCmd
	//
	char *NewBuff=NULL;
	ListCmdItemInfo *CorrenteListCmdItem;

	if (ListCmd==NULL) 
	{
		printf ("Riferimento: Tipo=%d Buff=%s\n",Tipo,Buff);
		WX11_FatalError ("Non posso registrare gli Item del ListCmd senza aver prima creato  il  ListCmd");
		
	}
		
		
	// Attenzione non rimuovere
	// 1 char in piu' nell'allocazione
	// error "invalid next size (normal)"
	// release II cambiato +10
	NewBuff=(char *) malloc (strlen(Buff)+ 10); //sizeof(char));
	if (!NewBuff)	WX11_FatalError ("Non posso allocare NewBuff ListCmd Item");

	//printf ("...Alloco Nuovo Buff %p\n",NewBuff);

	strcpy (NewBuff,Buff);
	
	CorrenteListCmdItem=(ListCmdItemInfo *) malloc (sizeof(ListCmdItemInfo)); 
	if (!CorrenteListCmdItem) WX11_FatalError ("Non posso allocare memoria ListCmd Item");

	//printf ("...Alloco Nuova ListCmdItem %p\n",CorrenteListCmdItem);

	CorrenteListCmdItem->Cmd=NULL;
	CorrenteListCmdItem->Tipo=Tipo;
	CorrenteListCmdItem->Buff=NewBuff;

	CorrenteListCmdItem->select=NULL;//-1;
	CorrenteListCmdItem->extra=NULL;

	CorrenteListCmdItem->Prev=ListCmd->UltimoItem;
	CorrenteListCmdItem->Next=NULL;

	if (!ListCmd->CorrenteItem)
		ListCmd->CorrenteItem=CorrenteListCmdItem;

	if (ListCmd->MaxLenItem < strlen(Buff))
		ListCmd->MaxLenItem = strlen(Buff);
	ListCmd->NumeroItem=ListCmd->NumeroItem+1;

	if (ListCmd->UltimoItem) (ListCmd->UltimoItem)->Next=CorrenteListCmdItem;

	if (!ListCmd->PrimoItem)  ListCmd->PrimoItem=CorrenteListCmdItem;

	ListCmd->UltimoItem=CorrenteListCmdItem;

	return (CorrenteListCmdItem);

}

ListCmdInfo *WX11_ListCmdAdd (char *Name)
{
	//
	// Aggiunge ListCmd
	//
	ListCmdInfo *CorrenteListCmd;
	ListCmdInfo *Ultima;

	CorrenteListCmd=(ListCmdInfo *) malloc (sizeof(ListCmdInfo));
	if (!CorrenteListCmd)	WX11_FatalError ("Non posso allocare WX11_ListCmdAddu");

	//printf ("WX11_ListCmdAdd %s (%p)\n",Name,CorrenteListCmd);

	Ultima=WX11_ListCmdLast (0,NULL);
	if (!Ultima)
		WX11_ListCmdFirst(1,CorrenteListCmd);
	else
		Ultima->Next=CorrenteListCmd;

        CorrenteListCmd->CmdPar=NULL;
        CorrenteListCmd->CmdOpen=NULL;
        CorrenteListCmd->CmdInput=NULL;

        CorrenteListCmd->State=0;

        CorrenteListCmd->NumeroItem=0;
	CorrenteListCmd->MaxLenItem=0;	

	CorrenteListCmd->Name=Name;
	CorrenteListCmd->signal=NULL;
	//
	CorrenteListCmd->PrimoItem=NULL;
	CorrenteListCmd->CorrenteItem=NULL;
	CorrenteListCmd->UltimoItem=NULL;
        //
	CorrenteListCmd->Prev=Ultima;
	CorrenteListCmd->Next=NULL;

	WX11_ListCmdLast(1,CorrenteListCmd);

	return (CorrenteListCmd);	
}

void ListCmdMakeSignals (CmdInfo *cmd, SignalHeaderInfo *signalhead)
{
	int x,num_signals;
	
	if (signalhead==NULL) return;

	num_signals=signalhead->num_signals;

	for (x=0;x<num_signals;x++)
	{
		WX11_SetSignalCallBack (
			cmd,
			signalhead->signals[x]->Tipo,
			signalhead->signals[x]->CallBack,
			signalhead->signals[x]->data);
	}
}

int IsListCmd (ListCmdInfo * lista)
{
	ListCmdInfo *Lista=WX11_ListCmdFirst (0,NULL);
	int f=0;
	while (Lista && !f)
	{
		if (Lista==lista)
		{
			f=1;
		}
		else
			Lista=Lista->Next;
	}
	return (f);
}

ListCmdInfo *CercaListCmdInfo (CmdInfo *cmd)
{
	ListCmdInfo *CorrenteListCmd=WX11_ListCmdFirst(0,NULL);	
	int f=0;
	
	while (CorrenteListCmd && !f)
	{
		if (CorrenteListCmd->CmdPar==cmd)
			f=1;
		else
			CorrenteListCmd=CorrenteListCmd->Next;
	}
	return (CorrenteListCmd);
}

ListCmdInfo *CercaListCmdOpen (CmdInfo *cmd)
{
	ListCmdInfo *CorrenteListCmd=WX11_ListCmdFirst(0,NULL);	
	int f=0;
	
	while (CorrenteListCmd && !f)
	{
		if (CorrenteListCmd->CmdOpen==cmd)
			f=1;
		else
			CorrenteListCmd=CorrenteListCmd->Next;
	}
	return (CorrenteListCmd);
}


ListCmdItemInfo *CercaListCmdItemInfo (ListCmdInfo *ListCmd, Window win)
{
	ListCmdItemInfo *CorrenteListCmdItemInfo=ListCmd->PrimoItem;	
	int f=0;
	
	while (CorrenteListCmdItemInfo && !f)
	{
		if ((CorrenteListCmdItemInfo->Cmd)->win==win)
			f=1;
		else
			CorrenteListCmdItemInfo=CorrenteListCmdItemInfo->Next;
	}
	return (CorrenteListCmdItemInfo);
}

