#!/usr/bin/env python

import re
import glob
import sys

if len(sys.argv) != 3:
    print 'usage: python post-doxy-1.5.6.py directory versionNumber'
    sys.exit(1)

path = str(sys.argv[1])

insertVersion = re.compile(r'VERSION_VERSION_VERSION')
insertSTLLink = re.compile(r'WWW_STL_DOCU')

hasAnchorDetails = re.compile(r'<a (class="anchor" |)name="_details">')

detailsHeading1 = re.compile(r'''<a name="_details"></a><h2>Detailed Description</h2>
<h3>''')
detailsHeading2 = re.compile(r'<a name="_details"></a><h2>Detailed Description</h2>')

mainHeading1 = re.compile(r'''(<!-- Generated by Doxygen \d+\.\d+\.\d+ -->)
(  <div class="navpath">.*
  </div>
|)<div class="contents">
<h1>(.*)( Class Template Reference| Struct Template Reference| Class Reference| Struct Reference)(<br>
<small>
.*</small>
|)</h1>''')

mainHeading2 = re.compile(r'''(<!-- Generated by Doxygen \d+\.\d+\.\d+ -->)
(  <div class="navpath">.*
  </div>
<div class="contents">
|<div class="contents">
|)<h1>(.*)()(<br>
<small>
.*</small>
|)</h1>''')

mainHeadingReplacement = '''\\1
<div class="contents">
<table class="main_heading">
<tr>
%s<td width="100%%">\\3\\5
</td>
<td align=right><a href="http://hci.iwr.uni-heidelberg.de/vigra/"><IMG border=0 ALT="VIGRA" SRC="documents/vigra.gif"></a></td></tr>
</table><p>
'''

detailsLink = '''<td align=left>
<A HREF ="#_details" ><IMG BORDER=0 ALT="details" SRC="documents/pfeilGross.gif"></A>
</td>
'''

indexPageHeading = re.compile(r'''<a class="anchor" name="_details"></a> <center> </center><h2><a class="anchor" name="Main">
(.*)
<center> Version''')
indexPageHeadingReplacement = '''<a class="anchor" name="_details"></a> <center> <h2 class="details_section"><a class="anchor" name="Main">
\\1
Version'''

templateDeclaration = re.compile('''<tr><td class="memTemplParams" nowrap colspan="2">([^<]*)</td></tr>\s*
<tr><td class="memTemplItemLeft" nowrap align="right" valign="top">[^<]*</td><td class="memTemplItemRight" valign="bottom"><a class="el" href=".*#([^"]+)">''')

templateDocumentation = '''(<a class="anchor" name="%s"></a>.*
<div class="memitem">
<div class="memproto">\s*
      <table class="memname">
        <tr>)'''

templateDocumentationReplacement = '''\\1
          <td colspan="4" class="memtemplate">%s</td></tr><tr>'''

def convertHeadings(text):
    if hasAnchorDetails.search(text):
        text = detailsHeading1.sub('<a name="_details"></a><h2 class="details_section">Detailed Description</h2>\n<h3 class="details_section">', \
                      text, 1)
        text = detailsHeading2.sub(r'<a name="_details"></a><h2 class="details_section">Detailed Description</h2>', \
                      text, 1)
        mhr = mainHeadingReplacement % detailsLink
    else:
        mhr = mainHeadingReplacement % ''
    text = mainHeading1.sub(mhr, text, 1)
    text = mainHeading2.sub(mhr, text, 1)
    return text

def insertMissingTemplateDeclarations(text):
    matches = templateDeclaration.findall(text)
    for k in matches:
        text = re.sub(templateDocumentation % k[1], templateDocumentationReplacement % k[0], text)
    return text

def processFile(fileName):
    print fileName          # log message
    f = open(fileName)
    text = f.read()
    f.close()
    
    text = insertVersion.sub(sys.argv[2], text)
    text = insertSTLLink.sub(r'http://www.sgi.com/tech/stl/', text)
    if re.search('.*/index.html', fileName) or re.search('.*\\index.html', fileName):
        text = re.sub(r'<h3 align="center">\d+\.\d+\.\d+ </h3>', '', text)
        text = indexPageHeading.sub(indexPageHeadingReplacement, text)
        
    text = convertHeadings(text)
    
    text = insertMissingTemplateDeclarations(text)

    f = open(fileName, 'w+')
    f.write(text)
    f.close()

files = glob.glob(path + '/*.html')  # use given path to files
#files = glob.glob('../doc/vigra/classes.html')

for file in files:
   processFile(file)
