/*  tiffe - Ti File Format Engine & Proxy
 *  Copyright (C) 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_ERRORMSG__
#define __TIFFEP_ERRORMSG__

/* Error codes: ERR_...  */
#define ERR_NONE             0  // No error

#define ERR_IPC_KEY          1  // Unable to get an IPC key
#define ERR_SHM_GET          2  // Unable to get a segment
#define ERR_SHM_ATT          3  // Unable to attach a segment
#define ERR_SHM_DTCH         4  // Unable to detach a segment
#define ERR_SHM_RMID         5  // Unable to remove a segment
#define ERR_CREATE_FILEMAP   6  // Unable to create a file-mapping
#define ERR_MAP_FILE	     7  // Unable to map the file
#define ERR_UNMAP_FILE       8  // Unable to unmap the file

#define ERR_SCK_SOCKET       10 // Unable to create a socket
#define ERR_SCK_BIND         11 // Unable to bind a socket
#define ERR_SCK_LISTEN       12 // Unable to listen a socket
#define ERR_SCK_ACCEPT       13 // Unable to accept the socket connection
#define ERR_SCK_CONNECT      14 // Unable to connect on the socket
#define ERR_SCK_SEND         15 // Unable to send data through socket
#define ERR_SCK_RECEIVE      16 // Unable to receive data from socket

#define ERR_FILE_OPEN        20 // Unable to open a file
#define ERR_INVALID_FILE     21 // Invalid TI file
#define ERR_PARSE_FILE       22 // Error while parsing the reg file
#define ERR_NOT_FOUND        23 // Plugin not found

#define ERR_CMD_INVALID      30 // Invalid command
#define ERR_INVALID_TYPE     31 // Invalid type ?
#define ERR_PLG_NOT_FOUND    32 // Plugin not found

#endif



