------------------------------------------------------------------------------
-- COMMON (C++ Interface)                                                   --
--                                                                          --
-- Part of TextTools                                                        --
-- Designed and Programmed by Ken O. Burtch                                 --
--                                                                          --
------------------------------------------------------------------------------
--                                                                          --
--                 Copyright (C) 1999-2003 Ken O. Burtch                    --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- This is maintained at http://www.vaxxine.com/pegasoft                    --
--                                                                          --
------------------------------------------------------------------------------
--with Gen_List;
--  pragma Elaborate( Gen_List ); -- remind Ada to elaborate generics first
--with Ada; use Ada;
--with Ada.Strings; use Ada.Strings; -- overrides our "strings" package
--with Ada.Strings.Bounded;
--with Ada.Strings.Maps;
--
--with Interfaces.C;
--use  Interfaces.C;
-- C language support

package Common.CPP is

--type C_String is new char_array(0..255 );
-- C-style string for C language support

-- Str255 Bounded String: C++ wrapper functions

type Str255List_List is record
     list : Str255List.List;
end record;
pragma export( CPP, Str255List_List, "str255list_list" );

-- procedure Str255List_Init( TheList : in out Str255List_List );
-- pragma export( CPP, Str255List_Init, "str255list_init" );

procedure Str255List_GetAllocation( allocation : out Str255List.AListIndex );
pragma export( CPP, Str255List_GetAllocation, "str255list_get_allocation" );

function Str255List_MemoryLeak( allocation : in Str255List.AListIndex ) return boolean;
pragma export( CPP, Str255List_MemoryLeak, "str255list_memory_leak" );

procedure Str255List_Compact( TheList : in out Str255List_List );
pragma export( CPP, Str255List_Compact, "str255list_compact" );

procedure Str255List_Clear( TheList : in out Str255List_List );
pragma export( CPP, Str255List_Clear, "str255list_clear" );

procedure Str255List_Copy( FromList, ToList : in out Str255List_List );
pragma export( CPP, Str255List_Copy, "str255list_copy" );

procedure Str255List_Copy2( FromList, ToList1, ToList2 : in out Str255List_List );
pragma export( CPP, Str255List_Copy2, "str255list_copy2" );

procedure Str255List_Move( FromList, ToList : in out Str255List_List );
pragma export( CPP, Str255List_Move, "str255list_move" );

procedure Str255List_Swap( List1, List2 : in out Str255List_List );
pragma export( CPP, Str255List_Swap, "str255list_swap" );

procedure Str255List_Push( TheList : in out Str255List_List; NewData : Str255 );
pragma export( CPP, Str255List_Push, "str255list_push" );

procedure Str255List_Queue( TheList : in out Str255List_List ; Data : Str255 );
pragma export( CPP, Str255List_Queue, "str255list_queue" );

procedure Str255List_Insert( TheList : in out Str255List_List ; Data : Str255 );
pragma export( CPP, Str255List_Insert, "str255list_insert" );

procedure Str255List_Insert2( TheList : in out Str255List_List ; atIndex : Str255List.AListIndex; Data : Str255 );
pragma export( CPP, Str255List_Insert2, "str255list_insert2" );

procedure Str255List_Pull( TheList : in out Str255List_List ; data : in out Str255 );
pragma export( CPP, Str255List_Pull, "str255list_pull" );

procedure Str255List_Discard( TheList : in out Str255List_List );
pragma export( CPP, Str255List_discard, "str255list_discard" );

procedure Str255List_Cut( TheList : in out Str255List_List; atIndex : Str255List.AListIndex;
   data : in out Str255 );
pragma export( CPP, Str255List_cut, "str255list_cut" );

procedure Str255List_ClearItem( TheList : in out Str255List_List ; atIndex : Str255List.AListIndex );
pragma export( CPP, Str255List_clearitem, "str255list_clearitem" );

procedure Str255List_Replace( TheList : in out Str255List_List; atIndex : Str255List.AListIndex; data : Str255 );
pragma export( CPP, Str255List_replace, "str255list_replace" );

procedure Str255List_Find( TheList : in out Str255List_List ; atIndex : Str255List.AListIndex ;
          data : in out Str255 );
pragma export( CPP, Str255List_find, "str255list_find" );

procedure Str255List_Lookup( TheList : in out Str255List_List ; data : Str255;
          start : Str255List.AListIndex; FoundAt : in out Str255List.AListIndex );
pragma export( CPP, Str255List_lookup, "str255list_lookup" );

function Str255List_Length( TheList : in Str255List_List ) return Str255List.AListIndex;
pragma export( CPP, Str255List_length, "str255list_length" );

function Str255List_IsEmpty( TheList : in Str255List_List ) return boolean;
pragma export( CPP, Str255List_IsEmpty, "str255list_is_empty" );

procedure Str255List_SubList( TheList : in out Str255List_List; index, len : Str255List.AListIndex; Result : in out Str255List_List );
pragma export( CPP, Str255List_SubList, "str255list_sublist" );

procedure Str255List_Concat( List1, List2 : Str255List_List; Result : in out Str255List_List );
pragma export( CPP, Str255List_Concat, "str255list_concat" );

--procedure Startup_Common( theProgramName, theShortProgramName : C_string );
--pragma export( C, Startup_Common, "startup_common" );


-- Boolean List: C++ wrapper functions

type BooleanList_List is record
     list : BooleanList.List;
end record;
pragma export( CPP, BooleanList_List, "booleanlist_list" );

-- procedure BooleanList_Init( TheList : in out BooleanList_List );
-- pragma export( CPP, BooleanList_Init, "booleanlist_init" );

procedure BooleanList_GetAllocation( allocation : out BooleanList.AListIndex );
pragma export( CPP, BooleanList_GetAllocation, "booleanlist_get_allocation" );

function BooleanList_MemoryLeak( allocation : in BooleanList.AListIndex ) return boolean;
pragma export( CPP, BooleanList_MemoryLeak, "booleanlist_memory_leak" );

procedure BooleanList_Compact( TheList : in out BooleanList_List );
pragma export( CPP, BooleanList_Compact, "booleanlist_compact" );

procedure BooleanList_Clear( TheList : in out BooleanList_List );
pragma export( CPP, BooleanList_Clear, "booleanlist_clear" );

procedure BooleanList_Copy( FromList, ToList : in out BooleanList_List );
pragma export( CPP, BooleanList_Copy, "booleanlist_copy" );

procedure BooleanList_Copy2( FromList, ToList1, ToList2 : in out BooleanList_List );
pragma export( CPP, BooleanList_Copy2, "booleanlist_copy2" );

procedure BooleanList_Move( FromList, ToList : in out BooleanList_List );
pragma export( CPP, BooleanList_Move, "booleanlist_move" );

procedure BooleanList_Swap( List1, List2 : in out BooleanList_List );
pragma export( CPP, BooleanList_Swap, "booleanlist_swap" );

procedure BooleanList_Push( TheList : in out BooleanList_List; NewData : boolean );
pragma export( CPP, BooleanList_Push, "booleanlist_push" );

procedure BooleanList_Queue( TheList : in out BooleanList_List ; Data : boolean );
pragma export( CPP, BooleanList_Queue, "booleanlist_queue" );

procedure BooleanList_Insert( TheList : in out BooleanList_List ; Data : boolean );
pragma export( CPP, BooleanList_Insert, "booleanlist_insert" );

procedure BooleanList_Insert2( TheList : in out BooleanList_List ; atIndex : BooleanList.AListIndex; Data : boolean );
pragma export( CPP, BooleanList_Insert2, "booleanlist_insert2" );

procedure BooleanList_Pull( TheList : in out BooleanList_List ; data : in out boolean );
pragma export( CPP, BooleanList_Pull, "booleanlist_pull" );

procedure BooleanList_Discard( TheList : in out BooleanList_List );
pragma export( CPP, BooleanList_discard, "booleanlist_discard" );

procedure BooleanList_Cut( TheList : in out BooleanList_List; atIndex : BooleanList.AListIndex; data : in out boolean );
pragma export( CPP, BooleanList_cut, "booleanlist_cut" );

procedure BooleanList_ClearItem( TheList : in out BooleanList_List ; atIndex : BooleanList.AListIndex );
pragma export( CPP, BooleanList_clearitem, "booleanlist_clearitem" );

procedure BooleanList_Replace( TheList : in out BooleanList_List; atIndex : BooleanList.AListIndex; data : boolean );
pragma export( CPP, BooleanList_replace, "booleanlist_replace" );

procedure BooleanList_Find( TheList : in out BooleanList_List ; atIndex : BooleanList.AListIndex ; data : in out boolean );
pragma export( CPP, BooleanList_find, "booleanlist_find" );

procedure BooleanList_Lookup( TheList : in out BooleanList_List ; data : boolean;
          start : BooleanList.AListIndex; FoundAt : in out BooleanList.AListIndex );
pragma export( CPP, BooleanList_lookup, "booleanlist_lookup" );

function BooleanList_Length( TheList : in BooleanList_List ) return BooleanList.AListIndex;
pragma export( CPP, BooleanList_length, "booleanlist_length" );

function BooleanList_IsEmpty( TheList : in BooleanList_List ) return boolean;
pragma export( CPP, BooleanList_IsEmpty, "booleanlist_is_empty" );

procedure BooleanList_SubList( TheList : in out BooleanList_List; index, len : BooleanList.AListIndex; Result : in out BooleanList_List );
pragma export( CPP, BooleanList_SubList, "booleanlist_sublist" );

procedure BooleanList_Concat( List1, List2 : BooleanList_List; Result : in out BooleanList_List );
pragma export( CPP, BooleanList_Concat, "booleanlist_concat" );

end Common.CPP;

